/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

@Deprecated(since="6.1")
public class Constants {
    private final String className;
    private final Map<String, Object> fieldCache = new HashMap<String, Object>();

    public Constants(Class<?> clazz) {
        Field[] fields2;
        Assert.notNull(clazz, "Class must not be null");
        this.className = clazz.getName();
        for (Field field : fields2 = clazz.getFields()) {
            if (!ReflectionUtils.isPublicStaticFinal(field)) continue;
            String name2 = field.getName();
            try {
                Object value2 = field.get(null);
                this.fieldCache.put(name2, value2);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public final String getClassName() {
        return this.className;
    }

    public final int getSize() {
        return this.fieldCache.size();
    }

    protected final Map<String, Object> getFieldCache() {
        return this.fieldCache;
    }

    public Number asNumber(String code) throws ConstantException {
        Object obj = this.asObject(code);
        if (!(obj instanceof Number)) {
            throw new ConstantException(this.className, code, "not a Number");
        }
        Number number = (Number)obj;
        return number;
    }

    public String asString(String code) throws ConstantException {
        return this.asObject(code).toString();
    }

    public Object asObject(String code) throws ConstantException {
        Assert.notNull((Object)code, "Code must not be null");
        String codeToUse = code.toUpperCase(Locale.ENGLISH);
        Object val = this.fieldCache.get(codeToUse);
        if (val == null) {
            throw new ConstantException(this.className, codeToUse, "not found");
        }
        return val;
    }

    public Set<String> getNames(@Nullable String namePrefix) {
        String prefixToUse = namePrefix != null ? namePrefix.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<String> names2 = new HashSet<String>();
        for (String code : this.fieldCache.keySet()) {
            if (!code.startsWith(prefixToUse)) continue;
            names2.add(code);
        }
        return names2;
    }

    public Set<String> getNamesForProperty(String propertyName) {
        return this.getNames(this.propertyToConstantNamePrefix(propertyName));
    }

    public Set<String> getNamesForSuffix(@Nullable String nameSuffix) {
        String suffixToUse = nameSuffix != null ? nameSuffix.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<String> names2 = new HashSet<String>();
        for (String code : this.fieldCache.keySet()) {
            if (!code.endsWith(suffixToUse)) continue;
            names2.add(code);
        }
        return names2;
    }

    public Set<Object> getValues(@Nullable String namePrefix) {
        String prefixToUse = namePrefix != null ? namePrefix.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<Object> values2 = new HashSet<Object>();
        this.fieldCache.forEach((code, value2) -> {
            if (code.startsWith(prefixToUse)) {
                values2.add(value2);
            }
        });
        return values2;
    }

    public Set<Object> getValuesForProperty(String propertyName) {
        return this.getValues(this.propertyToConstantNamePrefix(propertyName));
    }

    public Set<Object> getValuesForSuffix(@Nullable String nameSuffix) {
        String suffixToUse = nameSuffix != null ? nameSuffix.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<Object> values2 = new HashSet<Object>();
        this.fieldCache.forEach((code, value2) -> {
            if (code.endsWith(suffixToUse)) {
                values2.add(value2);
            }
        });
        return values2;
    }

    public String toCode(Object value2, @Nullable String namePrefix) throws ConstantException {
        String prefixToUse = namePrefix != null ? namePrefix.trim().toUpperCase(Locale.ENGLISH) : "";
        for (Map.Entry<String, Object> entry : this.fieldCache.entrySet()) {
            if (!entry.getKey().startsWith(prefixToUse) || !entry.getValue().equals(value2)) continue;
            return entry.getKey();
        }
        throw new ConstantException(this.className, prefixToUse, value2);
    }

    public String toCodeForProperty(Object value2, String propertyName) throws ConstantException {
        return this.toCode(value2, this.propertyToConstantNamePrefix(propertyName));
    }

    public String toCodeForSuffix(Object value2, @Nullable String nameSuffix) throws ConstantException {
        String suffixToUse = nameSuffix != null ? nameSuffix.trim().toUpperCase(Locale.ENGLISH) : "";
        for (Map.Entry<String, Object> entry : this.fieldCache.entrySet()) {
            if (!entry.getKey().endsWith(suffixToUse) || !entry.getValue().equals(value2)) continue;
            return entry.getKey();
        }
        throw new ConstantException(this.className, suffixToUse, value2);
    }

    public String propertyToConstantNamePrefix(String propertyName) {
        StringBuilder parsedPrefix = new StringBuilder();
        for (int i2 = 0; i2 < propertyName.length(); ++i2) {
            char c = propertyName.charAt(i2);
            if (Character.isUpperCase(c)) {
                parsedPrefix.append('_');
                parsedPrefix.append(c);
                continue;
            }
            parsedPrefix.append(Character.toUpperCase(c));
        }
        return parsedPrefix.toString();
    }

    public static class ConstantException
    extends IllegalArgumentException {
        public ConstantException(String className, String field, String message2) {
            super("Field '" + field + "' " + message2 + " in class [" + className + "]");
        }

        public ConstantException(String className, String namePrefix, Object value2) {
            super("No '" + namePrefix + "' field with value '" + value2 + "' found in class [" + className + "]");
        }
    }
}

