/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.weaving;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.weaving.LoadTimeWeaverAware;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class LoadTimeWeaverAwareProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    @Nullable
    private LoadTimeWeaver loadTimeWeaver;
    @Nullable
    private BeanFactory beanFactory;

    public LoadTimeWeaverAwareProcessor() {
    }

    public LoadTimeWeaverAwareProcessor(@Nullable LoadTimeWeaver loadTimeWeaver) {
        this.loadTimeWeaver = loadTimeWeaver;
    }

    public LoadTimeWeaverAwareProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof LoadTimeWeaverAware) {
            LoadTimeWeaverAware loadTimeWeaverAware = (LoadTimeWeaverAware)bean2;
            LoadTimeWeaver ltw = this.loadTimeWeaver;
            if (ltw == null) {
                Assert.state(this.beanFactory != null, "BeanFactory required if no LoadTimeWeaver explicitly specified");
                ltw = this.beanFactory.getBean("loadTimeWeaver", LoadTimeWeaver.class);
            }
            loadTimeWeaverAware.setLoadTimeWeaver(ltw);
        }
        return bean2;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String name2) {
        return bean2;
    }
}

