/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.core.NamedThreadLocal;
import org.springframework.lang.Nullable;

public class SimpleThreadScope
implements Scope {
    private static final Log logger = LogFactory.getLog(SimpleThreadScope.class);
    private final ThreadLocal<Map<String, Object>> threadScope = NamedThreadLocal.withInitial("SimpleThreadScope", HashMap::new);

    @Override
    public Object get(String name2, ObjectFactory<?> objectFactory) {
        Map<String, Object> scope = this.threadScope.get();
        Object scopedObject = scope.get(name2);
        if (scopedObject == null) {
            scopedObject = objectFactory.getObject();
            scope.put(name2, scopedObject);
        }
        return scopedObject;
    }

    @Override
    @Nullable
    public Object remove(String name2) {
        Map<String, Object> scope = this.threadScope.get();
        return scope.remove(name2);
    }

    @Override
    public void registerDestructionCallback(String name2, Runnable callback) {
        logger.warn("SimpleThreadScope does not support destruction callbacks. Consider using RequestScope in a web environment.");
    }

    @Override
    @Nullable
    public Object resolveContextualObject(String key2) {
        return null;
    }

    @Override
    public String getConversationId() {
        return Thread.currentThread().getName();
    }
}

