/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.Serializable;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultMessageSourceResolvable
implements MessageSourceResolvable,
Serializable {
    @Nullable
    private final String[] codes;
    @Nullable
    private final Object[] arguments;
    @Nullable
    private final String defaultMessage;

    public DefaultMessageSourceResolvable(String code) {
        this(new String[]{code}, null, null);
    }

    public DefaultMessageSourceResolvable(String[] codes) {
        this(codes, null, null);
    }

    public DefaultMessageSourceResolvable(String[] codes, String defaultMessage) {
        this(codes, null, defaultMessage);
    }

    public DefaultMessageSourceResolvable(String[] codes, Object[] arguments) {
        this(codes, arguments, null);
    }

    public DefaultMessageSourceResolvable(@Nullable String[] codes, @Nullable Object[] arguments, @Nullable String defaultMessage) {
        this.codes = codes;
        this.arguments = arguments;
        this.defaultMessage = defaultMessage;
    }

    public DefaultMessageSourceResolvable(MessageSourceResolvable resolvable) {
        this(resolvable.getCodes(), resolvable.getArguments(), resolvable.getDefaultMessage());
    }

    @Nullable
    public String getCode() {
        return this.codes != null && this.codes.length > 0 ? this.codes[this.codes.length - 1] : null;
    }

    @Override
    @Nullable
    public String[] getCodes() {
        return this.codes;
    }

    @Override
    @Nullable
    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    @Nullable
    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public boolean shouldRenderDefaultMessage() {
        return true;
    }

    protected final String resolvableToString() {
        StringBuilder result2 = new StringBuilder(64);
        result2.append("codes [").append(StringUtils.arrayToDelimitedString(this.codes, ","));
        result2.append("]; arguments [").append(StringUtils.arrayToDelimitedString(this.arguments, ","));
        result2.append("]; default message [").append(this.defaultMessage).append(']');
        return result2.toString();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.resolvableToString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof MessageSourceResolvable)) return false;
        MessageSourceResolvable that = (MessageSourceResolvable)other;
        if (!ObjectUtils.nullSafeEquals(this.getCodes(), that.getCodes())) return false;
        if (!ObjectUtils.nullSafeEquals(this.getArguments(), that.getArguments())) return false;
        if (!ObjectUtils.nullSafeEquals(this.getDefaultMessage(), that.getDefaultMessage())) return false;
        return true;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHash(this.getCode(), this.getArguments(), this.getDefaultMessage());
    }
}

