/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.core.OverridingClassLoader;
import org.springframework.core.SmartClassLoader;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

class ContextTypeMatchClassLoader
extends DecoratingClassLoader
implements SmartClassLoader {
    @Nullable
    private static final Method findLoadedClassMethod;
    private final Map<String, byte[]> bytesCache = new ConcurrentHashMap<String, byte[]>(256);

    public ContextTypeMatchClassLoader(@Nullable ClassLoader parent) {
        super(parent);
    }

    @Override
    public Class<?> loadClass(String name2) throws ClassNotFoundException {
        return new ContextOverridingClassLoader(this.getParent()).loadClass(name2);
    }

    @Override
    public boolean isClassReloadable(Class<?> clazz) {
        return clazz.getClassLoader() instanceof ContextOverridingClassLoader;
    }

    @Override
    public Class<?> publicDefineClass(String name2, byte[] b2, @Nullable ProtectionDomain protectionDomain) {
        return this.defineClass(name2, b2, 0, b2.length, protectionDomain);
    }

    static {
        Method method2;
        ClassLoader.registerAsParallelCapable();
        try {
            method2 = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            ReflectionUtils.makeAccessible(method2);
        }
        catch (Throwable ex) {
            method2 = null;
            LogFactory.getLog(ContextTypeMatchClassLoader.class).debug("ClassLoader.findLoadedClass not accessible -> will always override requested class", ex);
        }
        findLoadedClassMethod = method2;
    }

    private class ContextOverridingClassLoader
    extends OverridingClassLoader {
        public ContextOverridingClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected boolean isEligibleForOverriding(String className) {
            if (this.isExcluded(className) || ContextTypeMatchClassLoader.this.isExcluded(className)) {
                return false;
            }
            if (findLoadedClassMethod != null) {
                for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
                    if (ReflectionUtils.invokeMethod(findLoadedClassMethod, parent, className) == null) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        @Nullable
        protected Class<?> loadClassForOverriding(String name2) throws ClassNotFoundException {
            byte[] bytes2 = ContextTypeMatchClassLoader.this.bytesCache.get(name2);
            if (bytes2 == null) {
                bytes2 = this.loadBytesForClass(name2);
                if (bytes2 != null) {
                    ContextTypeMatchClassLoader.this.bytesCache.put(name2, bytes2);
                } else {
                    return null;
                }
            }
            return this.defineClass(name2, bytes2, 0, bytes2.length);
        }
    }
}

