/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.expression;

import java.util.Map;
import org.springframework.asm.MethodVisitor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.CompilablePropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MapAccessor
implements CompilablePropertyAccessor {
    @Override
    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{Map.class};
    }

    @Override
    public boolean canRead(EvaluationContext context, @Nullable Object target2, String name2) throws AccessException {
        Map map2;
        return target2 instanceof Map && (map2 = (Map)target2).containsKey(name2);
    }

    @Override
    public TypedValue read(EvaluationContext context, @Nullable Object target2, String name2) throws AccessException {
        Assert.state(target2 instanceof Map, "Target must be of type Map");
        Map map2 = (Map)target2;
        Object value2 = map2.get(name2);
        if (value2 == null && !map2.containsKey(name2)) {
            throw new MapAccessException(name2);
        }
        return new TypedValue(value2);
    }

    @Override
    public boolean canWrite(EvaluationContext context, @Nullable Object target2, String name2) throws AccessException {
        return true;
    }

    @Override
    public void write(EvaluationContext context, @Nullable Object target2, String name2, @Nullable Object newValue) throws AccessException {
        Assert.state(target2 instanceof Map, "Target must be a Map");
        Map map2 = (Map)target2;
        map2.put(name2, newValue);
    }

    @Override
    public boolean isCompilable() {
        return true;
    }

    @Override
    public Class<?> getPropertyType() {
        return Object.class;
    }

    @Override
    public void generateCode(String propertyName, MethodVisitor mv, CodeFlow cf) {
        String descriptor = cf.lastDescriptor();
        if (descriptor == null || !descriptor.equals("Ljava/util/Map")) {
            if (descriptor == null) {
                cf.loadTarget(mv);
            }
            CodeFlow.insertCheckCast(mv, "Ljava/util/Map");
        }
        mv.visitLdcInsn(propertyName);
        mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
    }

    private static class MapAccessException
    extends AccessException {
        private final String key;

        public MapAccessException(String key2) {
            super("");
            this.key = key2;
        }

        @Override
        public String getMessage() {
            return "Map does not contain a value for key '" + this.key + "'";
        }
    }
}

