/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.expression;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class BeanFactoryAccessor
implements PropertyAccessor {
    @Override
    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{BeanFactory.class};
    }

    @Override
    public boolean canRead(EvaluationContext context, @Nullable Object target2, String name2) throws AccessException {
        BeanFactory beanFactory;
        return target2 instanceof BeanFactory && (beanFactory = (BeanFactory)target2).containsBean(name2);
    }

    @Override
    public TypedValue read(EvaluationContext context, @Nullable Object target2, String name2) throws AccessException {
        Assert.state(target2 instanceof BeanFactory, "Target must be of type BeanFactory");
        return new TypedValue(((BeanFactory)target2).getBean(name2));
    }

    @Override
    public boolean canWrite(EvaluationContext context, @Nullable Object target2, String name2) throws AccessException {
        return false;
    }

    @Override
    public void write(EvaluationContext context, @Nullable Object target2, String name2, @Nullable Object newValue) throws AccessException {
        throw new AccessException("Beans in a BeanFactory are read-only");
    }
}

