/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.expression;

import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class BeanExpressionContextAccessor
implements PropertyAccessor {
    @Override
    public boolean canRead(EvaluationContext context, @Nullable Object target2, String name2) throws AccessException {
        BeanExpressionContext bec;
        return target2 instanceof BeanExpressionContext && (bec = (BeanExpressionContext)target2).containsObject(name2);
    }

    @Override
    public TypedValue read(EvaluationContext context, @Nullable Object target2, String name2) throws AccessException {
        Assert.state(target2 instanceof BeanExpressionContext, "Target must be of type BeanExpressionContext");
        return new TypedValue(((BeanExpressionContext)target2).getObject(name2));
    }

    @Override
    public boolean canWrite(EvaluationContext context, @Nullable Object target2, String name2) throws AccessException {
        return false;
    }

    @Override
    public void write(EvaluationContext context, @Nullable Object target2, String name2, @Nullable Object newValue) throws AccessException {
        throw new AccessException("Beans in a BeanFactory are read-only");
    }

    @Override
    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{BeanExpressionContext.class};
    }
}

