/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.expression;

import java.lang.reflect.AnnotatedElement;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class AnnotatedElementKey
implements Comparable<AnnotatedElementKey> {
    private final AnnotatedElement element;
    @Nullable
    private final Class<?> targetClass;

    public AnnotatedElementKey(AnnotatedElement element, @Nullable Class<?> targetClass) {
        Assert.notNull((Object)element, "AnnotatedElement must not be null");
        this.element = element;
        this.targetClass = targetClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof AnnotatedElementKey)) return false;
        AnnotatedElementKey that = (AnnotatedElementKey)other;
        if (!this.element.equals(that.element)) return false;
        if (!ObjectUtils.nullSafeEquals(this.targetClass, that.targetClass)) return false;
        return true;
    }

    public int hashCode() {
        return this.element.hashCode() + (this.targetClass != null ? this.targetClass.hashCode() * 29 : 0);
    }

    public String toString() {
        return this.element + (String)(this.targetClass != null ? " on " + this.targetClass : "");
    }

    @Override
    public int compareTo(AnnotatedElementKey other) {
        int result2 = this.element.toString().compareTo(other.element.toString());
        if (result2 == 0 && this.targetClass != null) {
            if (other.targetClass == null) {
                return 1;
            }
            result2 = this.targetClass.getName().compareTo(other.targetClass.getName());
        }
        return result2;
    }
}

