/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import java.util.function.Consumer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;

class GenericApplicationListenerDelegate<E extends ApplicationEvent>
implements GenericApplicationListener {
    private final Class<E> supportedEventType;
    private final Consumer<E> consumer;

    GenericApplicationListenerDelegate(Class<E> supportedEventType, Consumer<E> consumer) {
        this.supportedEventType = supportedEventType;
        this.consumer = consumer;
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event2) {
        this.consumer.accept((ApplicationEvent)this.supportedEventType.cast(event2));
    }

    @Override
    public boolean supportsEventType(ResolvableType eventType) {
        return this.supportedEventType.isAssignableFrom(eventType.toClass());
    }
}

