/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.aot.AotServices;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.log.LogMessage;
import org.springframework.lang.Nullable;

class RuntimeHintsBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    private static final Log logger = LogFactory.getLog(RuntimeHintsBeanFactoryInitializationAotProcessor.class);

    RuntimeHintsBeanFactoryInitializationAotProcessor() {
    }

    @Override
    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        Map registrars = AotServices.factories(beanFactory.getBeanClassLoader()).load(RuntimeHintsRegistrar.class).stream().collect(LinkedHashMap::new, (map2, item) -> map2.put(item.getClass(), item), Map::putAll);
        this.extractFromBeanFactory(beanFactory).forEach(registrarClass -> registrars.computeIfAbsent(registrarClass, BeanUtils::instantiateClass));
        return new RuntimeHintsRegistrarContribution(registrars.values(), beanFactory.getBeanClassLoader());
    }

    private Set<Class<? extends RuntimeHintsRegistrar>> extractFromBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        LinkedHashSet<Class<? extends RuntimeHintsRegistrar>> registrarClasses = new LinkedHashSet<Class<? extends RuntimeHintsRegistrar>>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            beanFactory.findAllAnnotationsOnBean(beanName, ImportRuntimeHints.class, true).forEach(annotation -> registrarClasses.addAll(this.extractFromBeanDefinition(beanName, (ImportRuntimeHints)annotation)));
        }
        return registrarClasses;
    }

    private Set<Class<? extends RuntimeHintsRegistrar>> extractFromBeanDefinition(String beanName, ImportRuntimeHints annotation) {
        LinkedHashSet<Class<? extends RuntimeHintsRegistrar>> registrars = new LinkedHashSet<Class<? extends RuntimeHintsRegistrar>>();
        for (Class<? extends RuntimeHintsRegistrar> registrarClass : annotation.value()) {
            if (logger.isTraceEnabled()) {
                logger.trace(LogMessage.format("Loaded [%s] registrar from annotated bean [%s]", (Object)registrarClass.getCanonicalName(), (Object)beanName));
            }
            registrars.add(registrarClass);
        }
        return registrars;
    }

    static class RuntimeHintsRegistrarContribution
    implements BeanFactoryInitializationAotContribution {
        private final Iterable<RuntimeHintsRegistrar> registrars;
        @Nullable
        private final ClassLoader beanClassLoader;

        RuntimeHintsRegistrarContribution(Iterable<RuntimeHintsRegistrar> registrars, @Nullable ClassLoader beanClassLoader) {
            this.registrars = registrars;
            this.beanClassLoader = beanClassLoader;
        }

        @Override
        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            RuntimeHints hints = generationContext.getRuntimeHints();
            this.registrars.forEach(registrar -> {
                if (logger.isTraceEnabled()) {
                    logger.trace(LogMessage.format("Processing RuntimeHints contribution from [%s]", (Object)registrar.getClass().getCanonicalName()));
                }
                registrar.registerHints(hints, this.beanClassLoader);
            });
        }
    }
}

