/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.annotation.ContextAnnotationAutowireCandidateResolver;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.ParameterizedTypeName;
import org.springframework.javapoet.TypeName;
import org.springframework.javapoet.TypeSpec;
import org.springframework.lang.Nullable;

class ApplicationContextInitializationCodeGenerator
implements BeanFactoryInitializationCode {
    private static final String INITIALIZE_METHOD = "initialize";
    private static final String APPLICATION_CONTEXT_VARIABLE = "applicationContext";
    private final GenericApplicationContext applicationContext;
    private final GeneratedClass generatedClass;
    private final List<MethodReference> initializers = new ArrayList<MethodReference>();

    ApplicationContextInitializationCodeGenerator(GenericApplicationContext applicationContext, GenerationContext generationContext) {
        this.applicationContext = applicationContext;
        this.generatedClass = generationContext.getGeneratedClasses().addForFeature("ApplicationContextInitializer", this::generateType);
        this.generatedClass.reserveMethodNames(INITIALIZE_METHOD);
    }

    private void generateType(TypeSpec.Builder type2) {
        type2.addJavadoc("{@link $T} to restore an application context based on previous AOT processing.", ApplicationContextInitializer.class);
        type2.addModifiers(Modifier.PUBLIC);
        type2.addSuperinterface(ParameterizedTypeName.get(ApplicationContextInitializer.class, new Type[]{GenericApplicationContext.class}));
        type2.addMethod(this.generateInitializeMethod());
    }

    private MethodSpec generateInitializeMethod() {
        MethodSpec.Builder method2 = MethodSpec.methodBuilder(INITIALIZE_METHOD);
        method2.addAnnotation(Override.class);
        method2.addModifiers(Modifier.PUBLIC);
        method2.addParameter((Type)((Object)GenericApplicationContext.class), APPLICATION_CONTEXT_VARIABLE, new Modifier[0]);
        method2.addCode(this.generateInitializeCode());
        return method2.build();
    }

    private CodeBlock generateInitializeCode() {
        CodeBlock.Builder code = CodeBlock.builder();
        code.addStatement("$T $L = $L.getDefaultListableBeanFactory()", DefaultListableBeanFactory.class, "beanFactory", APPLICATION_CONTEXT_VARIABLE);
        code.addStatement("$L.setAutowireCandidateResolver(new $T())", "beanFactory", ContextAnnotationAutowireCandidateResolver.class);
        code.addStatement("$L.setDependencyComparator($T.INSTANCE)", "beanFactory", AnnotationAwareOrderComparator.class);
        code.add(this.generateActiveProfilesInitializeCode());
        MethodReference.ArgumentCodeGenerator argCodeGenerator = ApplicationContextInitializationCodeGenerator.createInitializerMethodArgumentCodeGenerator();
        for (MethodReference initializer : this.initializers) {
            code.addStatement(initializer.toInvokeCodeBlock(argCodeGenerator, this.generatedClass.getName()));
        }
        return code.build();
    }

    private CodeBlock generateActiveProfilesInitializeCode() {
        CodeBlock.Builder code = CodeBlock.builder();
        ConfigurableEnvironment environment2 = this.applicationContext.getEnvironment();
        if (!Arrays.equals(environment2.getActiveProfiles(), environment2.getDefaultProfiles())) {
            for (String activeProfile : environment2.getActiveProfiles()) {
                code.addStatement("$L.getEnvironment().addActiveProfile($S)", APPLICATION_CONTEXT_VARIABLE, activeProfile);
            }
        }
        return code.build();
    }

    static MethodReference.ArgumentCodeGenerator createInitializerMethodArgumentCodeGenerator() {
        return MethodReference.ArgumentCodeGenerator.from(new InitializerMethodArgumentCodeGenerator());
    }

    GeneratedClass getGeneratedClass() {
        return this.generatedClass;
    }

    @Override
    public GeneratedMethods getMethods() {
        return this.generatedClass.getMethods();
    }

    @Override
    public void addInitializer(MethodReference methodReference) {
        this.initializers.add(methodReference);
    }

    private static class InitializerMethodArgumentCodeGenerator
    implements Function<TypeName, CodeBlock> {
        private InitializerMethodArgumentCodeGenerator() {
        }

        @Override
        @Nullable
        public CodeBlock apply(TypeName typeName) {
            CodeBlock codeBlock;
            if (typeName instanceof ClassName) {
                ClassName className = (ClassName)typeName;
                codeBlock = this.apply(className);
            } else {
                codeBlock = null;
            }
            return codeBlock;
        }

        @Override
        @Nullable
        private CodeBlock apply(ClassName className) {
            String name2 = className.canonicalName();
            if (name2.equals(DefaultListableBeanFactory.class.getName()) || name2.equals(ConfigurableListableBeanFactory.class.getName())) {
                return CodeBlock.of("beanFactory", new Object[0]);
            }
            if (name2.equals(ConfigurableEnvironment.class.getName()) || name2.equals(Environment.class.getName())) {
                return CodeBlock.of("$L.getEnvironment()", ApplicationContextInitializationCodeGenerator.APPLICATION_CONTEXT_VARIABLE);
            }
            if (name2.equals(ResourceLoader.class.getName())) {
                return CodeBlock.of(ApplicationContextInitializationCodeGenerator.APPLICATION_CONTEXT_VARIABLE, new Object[0]);
            }
            return null;
        }
    }
}

