/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context;

import org.springframework.context.ApplicationEvent;
import org.springframework.core.ResolvableType;
import org.springframework.core.ResolvableTypeProvider;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class PayloadApplicationEvent<T>
extends ApplicationEvent
implements ResolvableTypeProvider {
    private final T payload;
    private final ResolvableType payloadType;

    public PayloadApplicationEvent(Object source2, T payload) {
        this(source2, payload, null);
    }

    public PayloadApplicationEvent(Object source2, T payload, @Nullable ResolvableType payloadType) {
        super(source2);
        Assert.notNull(payload, "Payload must not be null");
        this.payload = payload;
        this.payloadType = payloadType != null ? payloadType : ResolvableType.forInstance(payload);
    }

    @Override
    public ResolvableType getResolvableType() {
        return ResolvableType.forClassWithGenerics(this.getClass(), this.payloadType);
    }

    public T getPayload() {
        return this.payload;
    }
}

