/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.util;

import java.lang.invoke.TypeDescriptor;
import java.util.Comparator;
import org.springframework.asm.ClassVisitor;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.ClassesKey;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.util.ParallelSorterEmitter;
import org.springframework.cglib.util.SorterTemplate;

public abstract class ParallelSorter
extends SorterTemplate {
    protected Object[] a;
    private Comparer comparer;

    protected ParallelSorter() {
    }

    public abstract ParallelSorter newInstance(Object[] var1);

    public static ParallelSorter create(Object[] arrays) {
        Generator gen = new Generator();
        gen.setArrays(arrays);
        return gen.create();
    }

    private int len() {
        return ((Object[])this.a[0]).length;
    }

    public void quickSort(int index2) {
        this.quickSort(index2, 0, this.len(), null);
    }

    public void quickSort(int index2, int lo, int hi) {
        this.quickSort(index2, lo, hi, null);
    }

    public void quickSort(int index2, Comparator cmp2) {
        this.quickSort(index2, 0, this.len(), cmp2);
    }

    public void quickSort(int index2, int lo, int hi, Comparator cmp2) {
        this.chooseComparer(index2, cmp2);
        super.quickSort(lo, hi - 1);
    }

    public void mergeSort(int index2) {
        this.mergeSort(index2, 0, this.len(), null);
    }

    public void mergeSort(int index2, int lo, int hi) {
        this.mergeSort(index2, lo, hi, null);
    }

    public void mergeSort(int index2, Comparator cmp2) {
        this.mergeSort(index2, 0, this.len(), cmp2);
    }

    public void mergeSort(int index2, int lo, int hi, Comparator cmp2) {
        this.chooseComparer(index2, cmp2);
        super.mergeSort(lo, hi - 1);
    }

    private void chooseComparer(int index2, Comparator cmp2) {
        Object array2 = this.a[index2];
        TypeDescriptor.OfField type2 = array2.getClass().componentType();
        this.comparer = type2.equals(Integer.TYPE) ? new IntComparer((int[])array2) : (type2.equals(Long.TYPE) ? new LongComparer((long[])array2) : (type2.equals(Double.TYPE) ? new DoubleComparer((double[])array2) : (type2.equals(Float.TYPE) ? new FloatComparer((float[])array2) : (type2.equals(Short.TYPE) ? new ShortComparer((short[])array2) : (type2.equals(Byte.TYPE) ? new ByteComparer((byte[])array2) : (cmp2 != null ? new ComparatorComparer((Object[])array2, cmp2) : new ObjectComparer((Object[])array2)))))));
    }

    @Override
    protected int compare(int i2, int j) {
        return this.comparer.compare(i2, j);
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(ParallelSorter.class.getName());
        private Object[] arrays;

        public Generator() {
            super(SOURCE);
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return null;
        }

        public void setArrays(Object[] arrays) {
            this.arrays = arrays;
        }

        public ParallelSorter create() {
            return (ParallelSorter)super.create(ClassesKey.create(this.arrays));
        }

        @Override
        public void generateClass(ClassVisitor v) throws Exception {
            if (this.arrays.length == 0) {
                throw new IllegalArgumentException("No arrays specified to sort");
            }
            for (Object array2 : this.arrays) {
                if (array2.getClass().isArray()) continue;
                throw new IllegalArgumentException(array2.getClass() + " is not an array");
            }
            new ParallelSorterEmitter(v, this.getClassName(), this.arrays);
        }

        @Override
        protected Object firstInstance(Class type2) {
            return ((ParallelSorter)ReflectUtils.newInstance(type2)).newInstance(this.arrays);
        }

        @Override
        protected Object nextInstance(Object instance) {
            return ((ParallelSorter)instance).newInstance(this.arrays);
        }
    }

    static class IntComparer
    implements Comparer {
        private final int[] a;

        public IntComparer(int[] a) {
            this.a = a;
        }

        @Override
        public int compare(int i2, int j) {
            return this.a[i2] - this.a[j];
        }
    }

    static interface Comparer {
        public int compare(int var1, int var2);
    }

    static class LongComparer
    implements Comparer {
        private final long[] a;

        public LongComparer(long[] a) {
            this.a = a;
        }

        @Override
        public int compare(int i2, int j) {
            long vi = this.a[i2];
            long vj = this.a[j];
            return Long.compare(vi, vj);
        }
    }

    static class DoubleComparer
    implements Comparer {
        private final double[] a;

        public DoubleComparer(double[] a) {
            this.a = a;
        }

        @Override
        public int compare(int i2, int j) {
            double vi = this.a[i2];
            double vj = this.a[j];
            return Double.compare(vi, vj);
        }
    }

    static class FloatComparer
    implements Comparer {
        private final float[] a;

        public FloatComparer(float[] a) {
            this.a = a;
        }

        @Override
        public int compare(int i2, int j) {
            float vi = this.a[i2];
            float vj = this.a[j];
            return Float.compare(vi, vj);
        }
    }

    static class ShortComparer
    implements Comparer {
        private final short[] a;

        public ShortComparer(short[] a) {
            this.a = a;
        }

        @Override
        public int compare(int i2, int j) {
            return this.a[i2] - this.a[j];
        }
    }

    static class ByteComparer
    implements Comparer {
        private final byte[] a;

        public ByteComparer(byte[] a) {
            this.a = a;
        }

        @Override
        public int compare(int i2, int j) {
            return this.a[i2] - this.a[j];
        }
    }

    static class ComparatorComparer
    implements Comparer {
        private final Object[] a;
        private final Comparator cmp;

        public ComparatorComparer(Object[] a, Comparator cmp2) {
            this.a = a;
            this.cmp = cmp2;
        }

        @Override
        public int compare(int i2, int j) {
            return this.cmp.compare(this.a[i2], this.a[j]);
        }
    }

    static class ObjectComparer
    implements Comparer {
        private final Object[] a;

        public ObjectComparer(Object[] a) {
            this.a = a;
        }

        @Override
        public int compare(int i2, int j) {
            return ((Comparable)this.a[i2]).compareTo(this.a[j]);
        }
    }
}

