/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.transform.impl;

import org.springframework.asm.Label;
import org.springframework.asm.Type;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.Local;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.transform.ClassEmitterTransformer;
import org.springframework.cglib.transform.impl.InterceptFieldFilter;

public class InterceptFieldTransformer
extends ClassEmitterTransformer {
    private static final String CALLBACK_FIELD = "$CGLIB_READ_WRITE_CALLBACK";
    private static final Type CALLBACK = TypeUtils.parseType("org.springframework.cglib.transform.impl.InterceptFieldCallback");
    private static final Type ENABLED = TypeUtils.parseType("org.springframework.cglib.transform.impl.InterceptFieldEnabled");
    private static final Signature ENABLED_SET = new Signature("setInterceptFieldCallback", Type.VOID_TYPE, new Type[]{CALLBACK});
    private static final Signature ENABLED_GET = new Signature("getInterceptFieldCallback", CALLBACK, new Type[0]);
    private InterceptFieldFilter filter;

    public InterceptFieldTransformer(InterceptFieldFilter filter2) {
        this.filter = filter2;
    }

    @Override
    public void begin_class(int version, int access, String className, Type superType, Type[] interfaces2, String sourceFile) {
        if (!TypeUtils.isInterface(access)) {
            super.begin_class(version, access, className, superType, TypeUtils.add(interfaces2, ENABLED), sourceFile);
            super.declare_field(130, CALLBACK_FIELD, CALLBACK, null);
            CodeEmitter e = super.begin_method(1, ENABLED_GET, null);
            e.load_this();
            e.getfield(CALLBACK_FIELD);
            e.return_value();
            e.end_method();
            e = super.begin_method(1, ENABLED_SET, null);
            e.load_this();
            e.load_arg(0);
            e.putfield(CALLBACK_FIELD);
            e.return_value();
            e.end_method();
        } else {
            super.begin_class(version, access, className, superType, interfaces2, sourceFile);
        }
    }

    @Override
    public void declare_field(int access, String name2, Type type2, Object value2) {
        super.declare_field(access, name2, type2, value2);
        if (!TypeUtils.isStatic(access)) {
            if (this.filter.acceptRead(this.getClassType(), name2)) {
                this.addReadMethod(name2, type2);
            }
            if (this.filter.acceptWrite(this.getClassType(), name2)) {
                this.addWriteMethod(name2, type2);
            }
        }
    }

    private void addReadMethod(String name2, Type type2) {
        CodeEmitter e = super.begin_method(1, InterceptFieldTransformer.readMethodSig(name2, type2.getDescriptor()), null);
        e.load_this();
        e.getfield(name2);
        e.load_this();
        e.invoke_interface(ENABLED, ENABLED_GET);
        Label intercept = e.make_label();
        e.ifnonnull(intercept);
        e.return_value();
        e.mark(intercept);
        Local result2 = e.make_local(type2);
        e.store_local(result2);
        e.load_this();
        e.invoke_interface(ENABLED, ENABLED_GET);
        e.load_this();
        e.push(name2);
        e.load_local(result2);
        e.invoke_interface(CALLBACK, InterceptFieldTransformer.readCallbackSig(type2));
        if (!TypeUtils.isPrimitive(type2)) {
            e.checkcast(type2);
        }
        e.return_value();
        e.end_method();
    }

    private void addWriteMethod(String name2, Type type2) {
        CodeEmitter e = super.begin_method(1, InterceptFieldTransformer.writeMethodSig(name2, type2.getDescriptor()), null);
        e.load_this();
        e.dup();
        e.invoke_interface(ENABLED, ENABLED_GET);
        Label skip2 = e.make_label();
        e.ifnull(skip2);
        e.load_this();
        e.invoke_interface(ENABLED, ENABLED_GET);
        e.load_this();
        e.push(name2);
        e.load_this();
        e.getfield(name2);
        e.load_arg(0);
        e.invoke_interface(CALLBACK, InterceptFieldTransformer.writeCallbackSig(type2));
        if (!TypeUtils.isPrimitive(type2)) {
            e.checkcast(type2);
        }
        Label go = e.make_label();
        e.goTo(go);
        e.mark(skip2);
        e.load_arg(0);
        e.mark(go);
        e.putfield(name2);
        e.return_value();
        e.end_method();
    }

    @Override
    public CodeEmitter begin_method(int access, Signature sig, Type[] exceptions) {
        return new CodeEmitter(super.begin_method(access, sig, exceptions)){

            @Override
            public void visitFieldInsn(int opcode, String owner2, String name2, String desc) {
                Type towner = TypeUtils.fromInternalName(owner2);
                switch (opcode) {
                    case 180: {
                        if (!InterceptFieldTransformer.this.filter.acceptRead(towner, name2)) break;
                        this.helper(towner, InterceptFieldTransformer.readMethodSig(name2, desc));
                        return;
                    }
                    case 181: {
                        if (!InterceptFieldTransformer.this.filter.acceptWrite(towner, name2)) break;
                        this.helper(towner, InterceptFieldTransformer.writeMethodSig(name2, desc));
                        return;
                    }
                }
                super.visitFieldInsn(opcode, owner2, name2, desc);
            }

            private void helper(Type owner2, Signature sig) {
                this.invoke_virtual(owner2, sig);
            }
        };
    }

    private static Signature readMethodSig(String name2, String desc) {
        return new Signature("$cglib_read_" + name2, "()" + desc);
    }

    private static Signature writeMethodSig(String name2, String desc) {
        return new Signature("$cglib_write_" + name2, "(" + desc + ")V");
    }

    private static Signature readCallbackSig(Type type2) {
        Type remap = InterceptFieldTransformer.remap(type2);
        return new Signature("read" + InterceptFieldTransformer.callbackName(remap), remap, new Type[]{Constants.TYPE_OBJECT, Constants.TYPE_STRING, remap});
    }

    private static Signature writeCallbackSig(Type type2) {
        Type remap = InterceptFieldTransformer.remap(type2);
        return new Signature("write" + InterceptFieldTransformer.callbackName(remap), remap, new Type[]{Constants.TYPE_OBJECT, Constants.TYPE_STRING, remap, remap});
    }

    private static Type remap(Type type2) {
        switch (type2.getSort()) {
            case 9: 
            case 10: {
                return Constants.TYPE_OBJECT;
            }
        }
        return type2;
    }

    private static String callbackName(Type type2) {
        return type2 == Constants.TYPE_OBJECT ? "Object" : TypeUtils.upperFirst(TypeUtils.getClassName(type2));
    }
}

