/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.transform.impl;

import java.util.HashMap;
import java.util.Map;
import org.springframework.asm.Label;
import org.springframework.asm.Type;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.ObjectSwitchCallback;
import org.springframework.cglib.core.ProcessSwitchCallback;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.transform.ClassEmitterTransformer;

public class FieldProviderTransformer
extends ClassEmitterTransformer {
    private static final String FIELD_NAMES = "CGLIB$FIELD_NAMES";
    private static final String FIELD_TYPES = "CGLIB$FIELD_TYPES";
    private static final Type FIELD_PROVIDER = TypeUtils.parseType("org.springframework.cglib.transform.impl.FieldProvider");
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType("IllegalArgumentException");
    private static final Signature PROVIDER_GET = TypeUtils.parseSignature("Object getField(String)");
    private static final Signature PROVIDER_SET = TypeUtils.parseSignature("void setField(String, Object)");
    private static final Signature PROVIDER_SET_BY_INDEX = TypeUtils.parseSignature("void setField(int, Object)");
    private static final Signature PROVIDER_GET_BY_INDEX = TypeUtils.parseSignature("Object getField(int)");
    private static final Signature PROVIDER_GET_TYPES = TypeUtils.parseSignature("Class[] getFieldTypes()");
    private static final Signature PROVIDER_GET_NAMES = TypeUtils.parseSignature("String[] getFieldNames()");
    private int access;
    private Map fields;

    @Override
    public void begin_class(int version, int access, String className, Type superType, Type[] interfaces2, String sourceFile) {
        if (!TypeUtils.isAbstract(access)) {
            interfaces2 = TypeUtils.add(interfaces2, FIELD_PROVIDER);
        }
        this.access = access;
        this.fields = new HashMap();
        super.begin_class(version, access, className, superType, interfaces2, sourceFile);
    }

    @Override
    public void declare_field(int access, String name2, Type type2, Object value2) {
        super.declare_field(access, name2, type2, value2);
        if (!TypeUtils.isStatic(access)) {
            this.fields.put(name2, type2);
        }
    }

    @Override
    public void end_class() {
        if (!TypeUtils.isInterface(this.access)) {
            try {
                this.generate();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CodeGenerationException(e);
            }
        }
        super.end_class();
    }

    private void generate() throws Exception {
        String[] names2 = this.fields.keySet().toArray(new String[this.fields.size()]);
        int[] indexes2 = new int[names2.length];
        for (int i2 = 0; i2 < indexes2.length; ++i2) {
            indexes2[i2] = i2;
        }
        super.declare_field(26, FIELD_NAMES, Constants.TYPE_STRING_ARRAY, null);
        super.declare_field(26, FIELD_TYPES, Constants.TYPE_CLASS_ARRAY, null);
        this.initFieldProvider(names2);
        this.getNames();
        this.getTypes();
        this.getField(names2);
        this.setField(names2);
        this.setByIndex(names2, indexes2);
        this.getByIndex(names2, indexes2);
    }

    private void initFieldProvider(String[] names2) {
        CodeEmitter e = this.getStaticHook();
        EmitUtils.push_object(e, names2);
        e.putstatic(this.getClassType(), FIELD_NAMES, Constants.TYPE_STRING_ARRAY);
        e.push(names2.length);
        e.newarray(Constants.TYPE_CLASS);
        e.dup();
        for (int i2 = 0; i2 < names2.length; ++i2) {
            e.dup();
            e.push(i2);
            Type type2 = (Type)this.fields.get(names2[i2]);
            EmitUtils.load_class(e, type2);
            e.aastore();
        }
        e.putstatic(this.getClassType(), FIELD_TYPES, Constants.TYPE_CLASS_ARRAY);
    }

    private void getNames() {
        CodeEmitter e = super.begin_method(1, PROVIDER_GET_NAMES, null);
        e.getstatic(this.getClassType(), FIELD_NAMES, Constants.TYPE_STRING_ARRAY);
        e.return_value();
        e.end_method();
    }

    private void getTypes() {
        CodeEmitter e = super.begin_method(1, PROVIDER_GET_TYPES, null);
        e.getstatic(this.getClassType(), FIELD_TYPES, Constants.TYPE_CLASS_ARRAY);
        e.return_value();
        e.end_method();
    }

    private void setByIndex(final String[] names2, int[] indexes2) throws Exception {
        final CodeEmitter e = super.begin_method(1, PROVIDER_SET_BY_INDEX, null);
        e.load_this();
        e.load_arg(1);
        e.load_arg(0);
        e.process_switch(indexes2, new ProcessSwitchCallback(){

            @Override
            public void processCase(int key2, Label end2) throws Exception {
                Type type2 = (Type)FieldProviderTransformer.this.fields.get(names2[key2]);
                e.unbox(type2);
                e.putfield(names2[key2]);
                e.return_value();
            }

            @Override
            public void processDefault() throws Exception {
                e.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Unknown field index");
            }
        });
        e.end_method();
    }

    private void getByIndex(final String[] names2, int[] indexes2) throws Exception {
        final CodeEmitter e = super.begin_method(1, PROVIDER_GET_BY_INDEX, null);
        e.load_this();
        e.load_arg(0);
        e.process_switch(indexes2, new ProcessSwitchCallback(){

            @Override
            public void processCase(int key2, Label end2) throws Exception {
                Type type2 = (Type)FieldProviderTransformer.this.fields.get(names2[key2]);
                e.getfield(names2[key2]);
                e.box(type2);
                e.return_value();
            }

            @Override
            public void processDefault() throws Exception {
                e.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Unknown field index");
            }
        });
        e.end_method();
    }

    private void getField(String[] names2) throws Exception {
        final CodeEmitter e = this.begin_method(1, PROVIDER_GET, null);
        e.load_this();
        e.load_arg(0);
        EmitUtils.string_switch(e, names2, 1, new ObjectSwitchCallback(){

            @Override
            public void processCase(Object key2, Label end2) {
                Type type2 = (Type)FieldProviderTransformer.this.fields.get(key2);
                e.getfield((String)key2);
                e.box(type2);
                e.return_value();
            }

            @Override
            public void processDefault() {
                e.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Unknown field name");
            }
        });
        e.end_method();
    }

    private void setField(String[] names2) throws Exception {
        final CodeEmitter e = this.begin_method(1, PROVIDER_SET, null);
        e.load_this();
        e.load_arg(1);
        e.load_arg(0);
        EmitUtils.string_switch(e, names2, 1, new ObjectSwitchCallback(){

            @Override
            public void processCase(Object key2, Label end2) {
                Type type2 = (Type)FieldProviderTransformer.this.fields.get(key2);
                e.unbox(type2);
                e.putfield((String)key2);
                e.return_value();
            }

            @Override
            public void processDefault() {
                e.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Unknown field name");
            }
        });
        e.end_method();
    }
}

