/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.reflect;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Type;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.Local;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;

public abstract class MulticastDelegate
implements Cloneable {
    protected Object[] targets = new Object[0];

    protected MulticastDelegate() {
    }

    public List getTargets() {
        return new ArrayList<Object>(Arrays.asList(this.targets));
    }

    public abstract MulticastDelegate add(Object var1);

    protected MulticastDelegate addHelper(Object target2) {
        MulticastDelegate copy2 = this.newInstance();
        copy2.targets = new Object[this.targets.length + 1];
        System.arraycopy(this.targets, 0, copy2.targets, 0, this.targets.length);
        copy2.targets[this.targets.length] = target2;
        return copy2;
    }

    public MulticastDelegate remove(Object target2) {
        for (int i2 = this.targets.length - 1; i2 >= 0; --i2) {
            if (!this.targets[i2].equals(target2)) continue;
            MulticastDelegate copy2 = this.newInstance();
            copy2.targets = new Object[this.targets.length - 1];
            System.arraycopy(this.targets, 0, copy2.targets, 0, i2);
            System.arraycopy(this.targets, i2 + 1, copy2.targets, i2, this.targets.length - i2 - 1);
            return copy2;
        }
        return this;
    }

    public abstract MulticastDelegate newInstance();

    public static MulticastDelegate create(Class iface) {
        Generator gen = new Generator();
        gen.setInterface(iface);
        return gen.create();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(MulticastDelegate.class.getName());
        private static final Type MULTICAST_DELEGATE = TypeUtils.parseType("org.springframework.cglib.reflect.MulticastDelegate");
        private static final Signature NEW_INSTANCE = new Signature("newInstance", MULTICAST_DELEGATE, new Type[0]);
        private static final Signature ADD_DELEGATE = new Signature("add", MULTICAST_DELEGATE, new Type[]{Constants.TYPE_OBJECT});
        private static final Signature ADD_HELPER = new Signature("addHelper", MULTICAST_DELEGATE, new Type[]{Constants.TYPE_OBJECT});
        private Class iface;

        public Generator() {
            super(SOURCE);
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.iface.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectUtils.getProtectionDomain(this.iface);
        }

        public void setInterface(Class iface) {
            this.iface = iface;
        }

        public MulticastDelegate create() {
            this.setNamePrefix(MulticastDelegate.class.getName());
            return (MulticastDelegate)super.create(this.iface.getName());
        }

        @Override
        public void generateClass(ClassVisitor cv) {
            MethodInfo method2 = ReflectUtils.getMethodInfo(ReflectUtils.findInterfaceMethod(this.iface));
            ClassEmitter ce = new ClassEmitter(cv);
            ce.begin_class(52, 1, this.getClassName(), MULTICAST_DELEGATE, new Type[]{Type.getType(this.iface)}, "<generated>");
            EmitUtils.null_constructor(ce);
            this.emitProxy(ce, method2);
            CodeEmitter e = ce.begin_method(1, NEW_INSTANCE, null);
            e.new_instance_this();
            e.dup();
            e.invoke_constructor_this();
            e.return_value();
            e.end_method();
            e = ce.begin_method(1, ADD_DELEGATE, null);
            e.load_this();
            e.load_arg(0);
            e.checkcast(Type.getType(this.iface));
            e.invoke_virtual_this(ADD_HELPER);
            e.return_value();
            e.end_method();
            ce.end_class();
        }

        private void emitProxy(ClassEmitter ce, MethodInfo method2) {
            int modifiers = 1;
            if ((method2.getModifiers() & 0x80) == 128) {
                modifiers |= 0x80;
            }
            CodeEmitter e = EmitUtils.begin_method(ce, method2, modifiers);
            Type returnType = method2.getSignature().getReturnType();
            boolean returns = returnType != Type.VOID_TYPE;
            Local result2 = null;
            if (returns) {
                result2 = e.make_local(returnType);
                e.zero_or_null(returnType);
                e.store_local(result2);
            }
            e.load_this();
            e.super_getfield("targets", Constants.TYPE_OBJECT_ARRAY);
            Local result22 = result2;
            EmitUtils.process_array(e, Constants.TYPE_OBJECT_ARRAY, type2 -> {
                e.checkcast(Type.getType(this.iface));
                e.load_args();
                e.invoke(method2);
                if (returns) {
                    e.store_local(result22);
                }
            });
            if (returns) {
                e.load_local(result2);
            }
            e.return_value();
            e.end_method();
        }

        @Override
        protected Object firstInstance(Class type2) {
            return ((MulticastDelegate)ReflectUtils.newInstance(type2)).newInstance();
        }

        @Override
        protected Object nextInstance(Object instance) {
            return ((MulticastDelegate)instance).newInstance();
        }
    }
}

