/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Type;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.reflect.FastClassEmitter;
import org.springframework.cglib.reflect.FastConstructor;
import org.springframework.cglib.reflect.FastMethod;

public abstract class FastClass {
    private Class type;

    protected FastClass() {
        throw new Error("Using the FastClass empty constructor--please report to the cglib-devel mailing list");
    }

    protected FastClass(Class type2) {
        this.type = type2;
    }

    public static FastClass create(Class type2) {
        return FastClass.create(type2.getClassLoader(), type2);
    }

    public static FastClass create(ClassLoader loader, Class type2) {
        Generator gen = new Generator();
        gen.setType(type2);
        gen.setClassLoader(loader);
        return gen.create();
    }

    public Object invoke(String name2, Class[] parameterTypes, Object obj, Object[] args2) throws InvocationTargetException {
        return this.invoke(this.getIndex(name2, parameterTypes), obj, args2);
    }

    public Object newInstance() throws InvocationTargetException {
        return this.newInstance(this.getIndex(Constants.EMPTY_CLASS_ARRAY), null);
    }

    public Object newInstance(Class[] parameterTypes, Object[] args2) throws InvocationTargetException {
        return this.newInstance(this.getIndex(parameterTypes), args2);
    }

    public FastMethod getMethod(Method method2) {
        return new FastMethod(this, method2);
    }

    public FastConstructor getConstructor(Constructor constructor2) {
        return new FastConstructor(this, constructor2);
    }

    public FastMethod getMethod(String name2, Class[] parameterTypes) {
        try {
            return this.getMethod(this.type.getMethod(name2, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    public FastConstructor getConstructor(Class[] parameterTypes) {
        try {
            return this.getConstructor(this.type.getConstructor(parameterTypes));
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    public String getName() {
        return this.type.getName();
    }

    public Class getJavaClass() {
        return this.type;
    }

    public String toString() {
        return this.type.toString();
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof FastClass)) {
            return false;
        }
        FastClass that = (FastClass)o;
        return this.type.equals(that.type);
    }

    public abstract int getIndex(String var1, Class[] var2);

    public abstract int getIndex(Class[] var1);

    public abstract Object invoke(int var1, Object var2, Object[] var3) throws InvocationTargetException;

    public abstract Object newInstance(int var1, Object[] var2) throws InvocationTargetException;

    public abstract int getIndex(Signature var1);

    public abstract int getMaxIndex();

    protected static String getSignatureWithoutReturnType(String name2, Class[] parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(name2);
        sb.append('(');
        for (Class parameterType : parameterTypes) {
            sb.append(Type.getDescriptor(parameterType));
        }
        sb.append(')');
        return sb.toString();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(FastClass.class.getName());
        private Class type;

        public Generator() {
            super(SOURCE);
        }

        public void setType(Class type2) {
            this.type = type2;
        }

        public FastClass create() {
            this.setNamePrefix(this.type.getName());
            return (FastClass)super.create(this.type.getName());
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.type.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectUtils.getProtectionDomain(this.type);
        }

        @Override
        public void generateClass(ClassVisitor v) throws Exception {
            new FastClassEmitter(v, this.getClassName(), this.type);
        }

        @Override
        protected Object firstInstance(Class type2) {
            return ReflectUtils.newInstance(type2, new Class[]{Class.class}, new Object[]{this.type});
        }

        @Override
        protected Object nextInstance(Object instance) {
            return instance;
        }
    }
}

