/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.springframework.cglib.core.internal.Function;

public class LoadingCache<K, KK, V> {
    protected final ConcurrentMap<KK, Object> map;
    protected final Function<K, V> loader;
    protected final Function<K, KK> keyMapper;
    public static final Function IDENTITY = key2 -> key2;

    public LoadingCache(Function<K, KK> keyMapper, Function<K, V> loader) {
        this.keyMapper = keyMapper;
        this.loader = loader;
        this.map = new ConcurrentHashMap<KK, Object>();
    }

    public static <K> Function<K, K> identity() {
        return IDENTITY;
    }

    public V get(K key2) {
        KK cacheKey = this.keyMapper.apply(key2);
        Object v = this.map.get(cacheKey);
        if (v != null && !(v instanceof FutureTask)) {
            return v;
        }
        return this.createEntry(key2, cacheKey, v);
    }

    protected V createEntry(K key2, KK cacheKey, Object v) {
        Object result2;
        FutureTask<Object> task;
        boolean creator = false;
        if (v != null) {
            task = (FutureTask<Object>)v;
        } else {
            task = new FutureTask<Object>(() -> this.loader.apply(key2));
            FutureTask<Object> prevTask = this.map.putIfAbsent(cacheKey, task);
            if (prevTask == null) {
                creator = true;
                task.run();
            } else if (prevTask instanceof FutureTask) {
                task = prevTask;
            } else {
                return (V)prevTask;
            }
        }
        try {
            result2 = task.get();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted while loading cache item", e);
        }
        catch (ExecutionException e) {
            Throwable cause2 = e.getCause();
            if (cause2 instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)cause2;
                throw runtimeException;
            }
            throw new IllegalStateException("Unable to load cache item", cause2);
        }
        if (creator) {
            this.map.put(cacheKey, result2);
        }
        return result2;
    }
}

