/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cglib.core.Customizer;
import org.springframework.cglib.core.KeyFactoryCustomizer;

public class CustomizerRegistry {
    private final Class[] customizerTypes;
    private Map<Class, List<KeyFactoryCustomizer>> customizers = new HashMap<Class, List<KeyFactoryCustomizer>>();

    public CustomizerRegistry(Class[] customizerTypes) {
        this.customizerTypes = customizerTypes;
    }

    public void add(KeyFactoryCustomizer customizer2) {
        Class<?> klass = customizer2.getClass();
        for (Class type2 : this.customizerTypes) {
            if (!type2.isAssignableFrom(klass)) continue;
            List list2 = this.customizers.computeIfAbsent(type2, k -> new ArrayList());
            list2.add(customizer2);
        }
    }

    public <T> List<T> get(Class<T> klass) {
        List<KeyFactoryCustomizer> list2 = this.customizers.get(klass);
        if (list2 == null) {
            return Collections.emptyList();
        }
        return list2;
    }

    @Deprecated
    public static CustomizerRegistry singleton(Customizer customizer2) {
        CustomizerRegistry registry = new CustomizerRegistry(new Class[]{Customizer.class});
        registry.add(customizer2);
        return registry;
    }
}

