/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.springframework.asm.Type;
import org.springframework.cglib.core.ClassInfo;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;

public class ReflectUtils {
    private static final Map primitives;
    private static final Map transforms;
    private static final ClassLoader defaultLoader;
    private static final Method classLoaderDefineClassMethod;
    private static final Throwable THROWABLE;
    private static final ProtectionDomain PROTECTION_DOMAIN;
    private static final List<Method> OBJECT_METHODS;
    private static BiConsumer<String, byte[]> generatedClassHandler;
    private static Consumer<Class<?>> loadedClassHandler;
    private static final String[] CGLIB_PACKAGES;

    private ReflectUtils() {
    }

    public static ProtectionDomain getProtectionDomain(Class source2) {
        if (source2 == null) {
            return null;
        }
        return source2.getProtectionDomain();
    }

    public static Type[] getExceptionTypes(Member member) {
        if (member instanceof Method) {
            Method method2 = (Method)member;
            return TypeUtils.getTypes(method2.getExceptionTypes());
        }
        if (member instanceof Constructor) {
            Constructor constructor2 = (Constructor)member;
            return TypeUtils.getTypes(constructor2.getExceptionTypes());
        }
        throw new IllegalArgumentException("Cannot get exception types of a field");
    }

    public static Signature getSignature(Member member) {
        if (member instanceof Method) {
            Method method2 = (Method)member;
            return new Signature(member.getName(), Type.getMethodDescriptor(method2));
        }
        if (member instanceof Constructor) {
            Constructor constructor2 = (Constructor)member;
            Type[] types = TypeUtils.getTypes(constructor2.getParameterTypes());
            return new Signature("<init>", Type.getMethodDescriptor(Type.VOID_TYPE, types));
        }
        throw new IllegalArgumentException("Cannot get signature of a field");
    }

    public static Constructor findConstructor(String desc) {
        return ReflectUtils.findConstructor(desc, defaultLoader);
    }

    public static Constructor findConstructor(String desc, ClassLoader loader) {
        try {
            int lparen = desc.indexOf(40);
            String className = desc.substring(0, lparen).trim();
            return ReflectUtils.getClass(className, loader).getConstructor(ReflectUtils.parseTypes(desc, loader));
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            throw new CodeGenerationException(ex);
        }
    }

    public static Method findMethod(String desc) {
        return ReflectUtils.findMethod(desc, defaultLoader);
    }

    public static Method findMethod(String desc, ClassLoader loader) {
        try {
            int lparen = desc.indexOf(40);
            int dot = desc.lastIndexOf(46, lparen);
            String className = desc.substring(0, dot).trim();
            String methodName = desc.substring(dot + 1, lparen).trim();
            return ReflectUtils.getClass(className, loader).getDeclaredMethod(methodName, ReflectUtils.parseTypes(desc, loader));
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            throw new CodeGenerationException(ex);
        }
    }

    private static Class[] parseTypes(String desc, ClassLoader loader) throws ClassNotFoundException {
        int comma;
        int lparen = desc.indexOf(40);
        int rparen = desc.indexOf(41, lparen);
        ArrayList<String> params2 = new ArrayList<String>();
        int start2 = lparen + 1;
        while ((comma = desc.indexOf(44, start2)) >= 0) {
            params2.add(desc.substring(start2, comma).trim());
            start2 = comma + 1;
        }
        if (start2 < rparen) {
            params2.add(desc.substring(start2, rparen).trim());
        }
        Class[] types = new Class[params2.size()];
        for (int i2 = 0; i2 < types.length; ++i2) {
            types[i2] = ReflectUtils.getClass((String)params2.get(i2), loader);
        }
        return types;
    }

    private static Class getClass(String className, ClassLoader loader) throws ClassNotFoundException {
        return ReflectUtils.getClass(className, loader, CGLIB_PACKAGES);
    }

    private static Class getClass(String className, ClassLoader loader, String[] packages) throws ClassNotFoundException {
        String save = className;
        int dimensions2 = 0;
        int index2 = 0;
        while ((index2 = className.indexOf("[]", index2) + 1) > 0) {
            ++dimensions2;
        }
        StringBuilder brackets = new StringBuilder(className.length() - dimensions2);
        for (int i2 = 0; i2 < dimensions2; ++i2) {
            brackets.append('[');
        }
        className = className.substring(0, className.length() - 2 * dimensions2);
        Object prefix = dimensions2 > 0 ? brackets + "L" : "";
        String suffix = dimensions2 > 0 ? ";" : "";
        try {
            return Class.forName((String)prefix + className + suffix, false, loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            for (String pkg : packages) {
                try {
                    return Class.forName((String)prefix + pkg + "." + className + suffix, false, loader);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                }
            }
            if (dimensions2 == 0) {
                Class c = (Class)primitives.get(className);
                if (c != null) {
                    return c;
                }
            } else {
                String transform = (String)transforms.get(className);
                if (transform != null) {
                    try {
                        return Class.forName(brackets + transform, false, loader);
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        // empty catch block
                    }
                }
            }
            throw new ClassNotFoundException(save);
        }
    }

    public static Object newInstance(Class type2) {
        return ReflectUtils.newInstance(type2, Constants.EMPTY_CLASS_ARRAY, null);
    }

    public static Object newInstance(Class type2, Class[] parameterTypes, Object[] args2) {
        return ReflectUtils.newInstance(ReflectUtils.getConstructor(type2, parameterTypes), args2);
    }

    public static Object newInstance(Constructor cstruct, Object[] args2) {
        boolean flag = cstruct.isAccessible();
        try {
            Object result2;
            if (!flag) {
                cstruct.setAccessible(true);
            }
            Object t = result2 = cstruct.newInstance(args2);
            return t;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CodeGenerationException(e);
        }
        catch (InvocationTargetException e) {
            throw new CodeGenerationException(e.getTargetException());
        }
        finally {
            if (!flag) {
                cstruct.setAccessible(flag);
            }
        }
    }

    public static Constructor getConstructor(Class type2, Class[] parameterTypes) {
        try {
            Constructor constructor2 = type2.getDeclaredConstructor(parameterTypes);
            constructor2.setAccessible(true);
            return constructor2;
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
    }

    public static String[] getNames(Class[] classes) {
        if (classes == null) {
            return null;
        }
        String[] names2 = new String[classes.length];
        for (int i2 = 0; i2 < names2.length; ++i2) {
            names2[i2] = classes[i2].getName();
        }
        return names2;
    }

    public static Class[] getClasses(Object[] objects) {
        Class[] classes = new Class[objects.length];
        for (int i2 = 0; i2 < objects.length; ++i2) {
            classes[i2] = objects[i2].getClass();
        }
        return classes;
    }

    public static Method findNewInstance(Class iface) {
        Method m = ReflectUtils.findInterfaceMethod(iface);
        if (!m.getName().equals("newInstance")) {
            throw new IllegalArgumentException(iface + " missing newInstance method");
        }
        return m;
    }

    public static Method[] getPropertyMethods(PropertyDescriptor[] properties, boolean read2, boolean write2) {
        HashSet<Method> methods2 = new HashSet<Method>();
        for (PropertyDescriptor pd : properties) {
            if (read2) {
                methods2.add(pd.getReadMethod());
            }
            if (!write2) continue;
            methods2.add(pd.getWriteMethod());
        }
        methods2.remove(null);
        return methods2.toArray(new Method[methods2.size()]);
    }

    public static PropertyDescriptor[] getBeanProperties(Class type2) {
        return ReflectUtils.getPropertiesHelper(type2, true, true);
    }

    public static PropertyDescriptor[] getBeanGetters(Class type2) {
        return ReflectUtils.getPropertiesHelper(type2, true, false);
    }

    public static PropertyDescriptor[] getBeanSetters(Class type2) {
        return ReflectUtils.getPropertiesHelper(type2, false, true);
    }

    private static PropertyDescriptor[] getPropertiesHelper(Class type2, boolean read2, boolean write2) {
        try {
            BeanInfo info = Introspector.getBeanInfo(type2, Object.class);
            PropertyDescriptor[] all = info.getPropertyDescriptors();
            if (read2 && write2) {
                return all;
            }
            ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(all.length);
            for (PropertyDescriptor pd : all) {
                if ((!read2 || pd.getReadMethod() == null) && (!write2 || pd.getWriteMethod() == null)) continue;
                properties.add(pd);
            }
            return properties.toArray(new PropertyDescriptor[properties.size()]);
        }
        catch (IntrospectionException e) {
            throw new CodeGenerationException(e);
        }
    }

    public static Method findDeclaredMethod(Class type2, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        for (Class cl = type2; cl != null; cl = cl.getSuperclass()) {
            try {
                return cl.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    public static List addAllMethods(Class type2, List list2) {
        Class<?>[] interfaces2;
        if (type2 == Object.class) {
            list2.addAll(OBJECT_METHODS);
        } else {
            list2.addAll(Arrays.asList(type2.getDeclaredMethods()));
        }
        Class superclass2 = type2.getSuperclass();
        if (superclass2 != null) {
            ReflectUtils.addAllMethods(superclass2, list2);
        }
        for (Class<?> element : interfaces2 = type2.getInterfaces()) {
            ReflectUtils.addAllMethods(element, list2);
        }
        return list2;
    }

    public static List addAllInterfaces(Class type2, List list2) {
        Class superclass2 = type2.getSuperclass();
        if (superclass2 != null) {
            list2.addAll(Arrays.asList(type2.getInterfaces()));
            ReflectUtils.addAllInterfaces(superclass2, list2);
        }
        return list2;
    }

    public static Method findInterfaceMethod(Class iface) {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(iface + " is not an interface");
        }
        Method[] methods2 = iface.getDeclaredMethods();
        if (methods2.length != 1) {
            throw new IllegalArgumentException("expecting exactly 1 method in " + iface);
        }
        return methods2[0];
    }

    public static void setGeneratedClassHandler(BiConsumer<String, byte[]> handler) {
        generatedClassHandler = handler;
    }

    public static Class defineClass(String className, byte[] b2, ClassLoader loader) throws Exception {
        return ReflectUtils.defineClass(className, b2, loader, null, null);
    }

    public static Class defineClass(String className, byte[] b2, ClassLoader loader, ProtectionDomain protectionDomain) throws Exception {
        return ReflectUtils.defineClass(className, b2, loader, protectionDomain, null);
    }

    public static Class defineClass(String className, byte[] b2, final ClassLoader loader, ProtectionDomain protectionDomain, final Class<?> contextClass) throws Exception {
        MethodHandles.Lookup lookup;
        Class c = null;
        Throwable t = THROWABLE;
        BiConsumer<String, byte[]> handlerToUse = generatedClassHandler;
        if (handlerToUse != null) {
            handlerToUse.accept(className, b2);
        }
        if (contextClass != null && contextClass.getClassLoader() == loader) {
            try {
                lookup = MethodHandles.privateLookupIn(contextClass, MethodHandles.lookup());
                c = lookup.defineClass(b2);
            }
            catch (IllegalArgumentException | LinkageError ex) {
                t = ex;
            }
            catch (Throwable ex) {
                throw new CodeGenerationException(ex);
            }
        }
        if (c == null) {
            if (protectionDomain == null) {
                protectionDomain = PROTECTION_DOMAIN;
            }
            try {
                Method publicDefineClass = loader.getClass().getMethod("publicDefineClass", String.class, byte[].class, ProtectionDomain.class);
                c = (Class)publicDefineClass.invoke((Object)loader, className, b2, protectionDomain);
            }
            catch (InvocationTargetException ex) {
                if (!(ex.getTargetException() instanceof UnsupportedOperationException)) {
                    throw new CodeGenerationException(ex.getTargetException());
                }
                t = ex.getTargetException();
            }
            catch (Throwable ex) {
                t = ex;
            }
            if (c == null && classLoaderDefineClassMethod != null) {
                Object[] args2 = new Object[]{className, b2, 0, b2.length, protectionDomain};
                try {
                    if (!classLoaderDefineClassMethod.isAccessible()) {
                        classLoaderDefineClassMethod.setAccessible(true);
                    }
                    c = (Class)classLoaderDefineClassMethod.invoke((Object)loader, args2);
                }
                catch (InvocationTargetException ex) {
                    throw new CodeGenerationException(ex.getTargetException());
                }
                catch (InaccessibleObjectException ex) {
                    t = ex;
                }
                catch (Throwable ex) {
                    throw new CodeGenerationException(ex);
                }
            }
        }
        if (c == null && contextClass != null && contextClass.getClassLoader() != loader) {
            try {
                lookup = MethodHandles.privateLookupIn(contextClass, MethodHandles.lookup());
                c = lookup.defineClass(b2);
            }
            catch (IllegalAccessException | LinkageError ex) {
                throw new CodeGenerationException(ex){

                    @Override
                    public String getMessage() {
                        return "ClassLoader mismatch for [" + contextClass.getName() + "]: JVM should be started with --add-opens=java.base/java.lang=ALL-UNNAMED for ClassLoader.defineClass to be accessible on " + loader.getClass().getName() + "; consider co-locating the affected class in that target ClassLoader instead.";
                    }
                };
            }
            catch (Throwable ex) {
                throw new CodeGenerationException(ex);
            }
        }
        if (c == null) {
            throw new CodeGenerationException(t){

                @Override
                public String getMessage() {
                    return "No compatible defineClass mechanism detected: JVM should be started with --add-opens=java.base/java.lang=ALL-UNNAMED for ClassLoader.defineClass to be accessible. On the module path, you may not be able to define this CGLIB-generated class at all.";
                }
            };
        }
        Class.forName(className, true, loader);
        return c;
    }

    public static void setLoadedClassHandler(Consumer<Class<?>> loadedClassHandler) {
        ReflectUtils.loadedClassHandler = loadedClassHandler;
    }

    public static Class<?> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className, true, classLoader);
        Consumer<Class<?>> handlerToUse = loadedClassHandler;
        if (handlerToUse != null) {
            handlerToUse.accept(clazz);
        }
        return clazz;
    }

    public static int findPackageProtected(Class[] classes) {
        for (int i2 = 0; i2 < classes.length; ++i2) {
            if (Modifier.isPublic(classes[i2].getModifiers())) continue;
            return i2;
        }
        return 0;
    }

    public static MethodInfo getMethodInfo(final Member member, final int modifiers) {
        final Signature sig = ReflectUtils.getSignature(member);
        return new MethodInfo(){
            private ClassInfo ci;

            @Override
            public ClassInfo getClassInfo() {
                if (this.ci == null) {
                    this.ci = ReflectUtils.getClassInfo(member.getDeclaringClass());
                }
                return this.ci;
            }

            @Override
            public int getModifiers() {
                return modifiers;
            }

            @Override
            public Signature getSignature() {
                return sig;
            }

            @Override
            public Type[] getExceptionTypes() {
                return ReflectUtils.getExceptionTypes(member);
            }
        };
    }

    public static MethodInfo getMethodInfo(Member member) {
        return ReflectUtils.getMethodInfo(member, member.getModifiers());
    }

    public static ClassInfo getClassInfo(final Class clazz) {
        final Type type2 = Type.getType(clazz);
        final Type sc = clazz.getSuperclass() == null ? null : Type.getType(clazz.getSuperclass());
        return new ClassInfo(){

            @Override
            public Type getType() {
                return type2;
            }

            @Override
            public Type getSuperType() {
                return sc;
            }

            @Override
            public Type[] getInterfaces() {
                return TypeUtils.getTypes(clazz.getInterfaces());
            }

            @Override
            public int getModifiers() {
                return clazz.getModifiers();
            }
        };
    }

    public static Method[] findMethods(String[] namesAndDescriptors, Method[] methods2) {
        HashMap<CallSite, Method> map2 = new HashMap<CallSite, Method>();
        for (Method method2 : methods2) {
            map2.put((CallSite)((Object)(method2.getName() + Type.getMethodDescriptor(method2))), method2);
        }
        Method[] result2 = new Method[namesAndDescriptors.length / 2];
        for (int i2 = 0; i2 < result2.length; ++i2) {
            result2[i2] = (Method)map2.get(namesAndDescriptors[i2 * 2] + namesAndDescriptors[i2 * 2 + 1]);
            if (result2[i2] != null) continue;
        }
        return result2;
    }

    static {
        Method classLoaderDefineClass;
        primitives = new HashMap(8);
        transforms = new HashMap(8);
        defaultLoader = ReflectUtils.class.getClassLoader();
        OBJECT_METHODS = new ArrayList<Method>();
        Throwable throwable = null;
        try {
            classLoaderDefineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
        }
        catch (Throwable t) {
            classLoaderDefineClass = null;
            throwable = t;
        }
        classLoaderDefineClassMethod = classLoaderDefineClass;
        THROWABLE = throwable;
        PROTECTION_DOMAIN = ReflectUtils.getProtectionDomain(ReflectUtils.class);
        for (Method method2 : Object.class.getDeclaredMethods()) {
            if ("finalize".equals(method2.getName()) || (method2.getModifiers() & 0x18) > 0) continue;
            OBJECT_METHODS.add(method2);
        }
        CGLIB_PACKAGES = new String[]{"java.lang"};
        primitives.put("byte", Byte.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        transforms.put("byte", "B");
        transforms.put("char", "C");
        transforms.put("double", "D");
        transforms.put("float", "F");
        transforms.put("int", "I");
        transforms.put("long", "J");
        transforms.put("short", "S");
        transforms.put("boolean", "Z");
    }
}

