/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core;

import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.cglib.core.Constants;

public class LocalVariablesSorter
extends MethodVisitor {
    protected final int firstLocal;
    private final State state;

    public LocalVariablesSorter(int access, String desc, MethodVisitor mv) {
        super(Constants.ASM_API, mv);
        this.state = new State();
        Type[] args2 = Type.getArgumentTypes(desc);
        this.state.nextLocal = (8 & access) != 0 ? 0 : 1;
        for (Type arg2 : args2) {
            this.state.nextLocal += arg2.getSize();
        }
        this.firstLocal = this.state.nextLocal;
    }

    public LocalVariablesSorter(LocalVariablesSorter lvs) {
        super(Constants.ASM_API, lvs.mv);
        this.state = lvs.state;
        this.firstLocal = lvs.firstLocal;
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        int size2 = switch (opcode) {
            case 22, 24, 55, 57 -> 2;
            default -> 1;
        };
        this.mv.visitVarInsn(opcode, this.remap(var, size2));
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.mv.visitIincInsn(this.remap(var, 1), increment);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitMaxs(maxStack, this.state.nextLocal);
    }

    @Override
    public void visitLocalVariable(String name2, String desc, String signature, Label start2, Label end2, int index2) {
        this.mv.visitLocalVariable(name2, desc, signature, start2, end2, this.remap(index2));
    }

    protected int newLocal(int size2) {
        int var = this.state.nextLocal;
        this.state.nextLocal += size2;
        return var;
    }

    private int remap(int var, int size2) {
        int value2;
        if (var < this.firstLocal) {
            return var;
        }
        int key2 = 2 * var + size2 - 1;
        int length2 = this.state.mapping.length;
        if (key2 >= length2) {
            int[] newMapping = new int[Math.max(2 * length2, key2 + 1)];
            System.arraycopy(this.state.mapping, 0, newMapping, 0, length2);
            this.state.mapping = newMapping;
        }
        if ((value2 = this.state.mapping[key2]) == 0) {
            this.state.mapping[key2] = value2 = this.state.nextLocal + 1;
            this.state.nextLocal += size2;
        }
        return value2 - 1;
    }

    private int remap(int var) {
        int value2;
        if (var < this.firstLocal) {
            return var;
        }
        int key2 = 2 * var;
        int n = value2 = key2 < this.state.mapping.length ? this.state.mapping[key2] : 0;
        if (value2 == 0) {
            int n2 = value2 = key2 + 1 < this.state.mapping.length ? this.state.mapping[key2 + 1] : 0;
        }
        if (value2 == 0) {
            throw new IllegalStateException("Unknown local variable " + var);
        }
        return value2 - 1;
    }

    private static class State {
        int[] mapping = new int[40];
        int nextLocal;

        private State() {
        }
    }
}

