/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.asm.Label;
import org.springframework.asm.Type;
import org.springframework.cglib.core.Block;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.core.CollectionUtils;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.Customizer;
import org.springframework.cglib.core.HashCodeCustomizer;
import org.springframework.cglib.core.Local;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.ObjectSwitchCallback;
import org.springframework.cglib.core.ProcessArrayCallback;
import org.springframework.cglib.core.ProcessSwitchCallback;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.core.internal.CustomizerRegistry;

public class EmitUtils {
    private static final Signature CSTRUCT_NULL = TypeUtils.parseConstructor("");
    private static final Signature CSTRUCT_THROWABLE = TypeUtils.parseConstructor("Throwable");
    private static final Signature GET_NAME = TypeUtils.parseSignature("String getName()");
    private static final Signature HASH_CODE = TypeUtils.parseSignature("int hashCode()");
    private static final Signature EQUALS = TypeUtils.parseSignature("boolean equals(Object)");
    private static final Signature STRING_LENGTH = TypeUtils.parseSignature("int length()");
    private static final Signature STRING_CHAR_AT = TypeUtils.parseSignature("char charAt(int)");
    private static final Signature FOR_NAME = TypeUtils.parseSignature("Class forName(String)");
    private static final Signature DOUBLE_TO_LONG_BITS = TypeUtils.parseSignature("long doubleToLongBits(double)");
    private static final Signature FLOAT_TO_INT_BITS = TypeUtils.parseSignature("int floatToIntBits(float)");
    private static final Signature TO_STRING = TypeUtils.parseSignature("String toString()");
    private static final Signature APPEND_STRING = TypeUtils.parseSignature("StringBuffer append(String)");
    private static final Signature APPEND_INT = TypeUtils.parseSignature("StringBuffer append(int)");
    private static final Signature APPEND_DOUBLE = TypeUtils.parseSignature("StringBuffer append(double)");
    private static final Signature APPEND_FLOAT = TypeUtils.parseSignature("StringBuffer append(float)");
    private static final Signature APPEND_CHAR = TypeUtils.parseSignature("StringBuffer append(char)");
    private static final Signature APPEND_LONG = TypeUtils.parseSignature("StringBuffer append(long)");
    private static final Signature APPEND_BOOLEAN = TypeUtils.parseSignature("StringBuffer append(boolean)");
    private static final Signature LENGTH = TypeUtils.parseSignature("int length()");
    private static final Signature SET_LENGTH = TypeUtils.parseSignature("void setLength(int)");
    private static final Signature GET_DECLARED_METHOD = TypeUtils.parseSignature("java.lang.reflect.Method getDeclaredMethod(String, Class[])");
    public static final ArrayDelimiters DEFAULT_DELIMITERS = new ArrayDelimiters("{", ", ", "}");

    private EmitUtils() {
    }

    public static void factory_method(ClassEmitter ce, Signature sig) {
        CodeEmitter e = ce.begin_method(1, sig, null);
        e.new_instance_this();
        e.dup();
        e.load_args();
        e.invoke_constructor_this(TypeUtils.parseConstructor(sig.getArgumentTypes()));
        e.return_value();
        e.end_method();
    }

    public static void null_constructor(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(1, CSTRUCT_NULL, null);
        e.load_this();
        e.super_invoke_constructor();
        e.return_value();
        e.end_method();
    }

    public static void process_array(CodeEmitter e, Type type2, ProcessArrayCallback callback) {
        Type componentType = TypeUtils.getComponentType(type2);
        Local array2 = e.make_local();
        Local loopvar = e.make_local(Type.INT_TYPE);
        Label loopbody = e.make_label();
        Label checkloop = e.make_label();
        e.store_local(array2);
        e.push(0);
        e.store_local(loopvar);
        e.goTo(checkloop);
        e.mark(loopbody);
        e.load_local(array2);
        e.load_local(loopvar);
        e.array_load(componentType);
        callback.processElement(componentType);
        e.iinc(loopvar, 1);
        e.mark(checkloop);
        e.load_local(loopvar);
        e.load_local(array2);
        e.arraylength();
        e.if_icmp(155, loopbody);
    }

    public static void process_arrays(CodeEmitter e, Type type2, ProcessArrayCallback callback) {
        Type componentType = TypeUtils.getComponentType(type2);
        Local array1 = e.make_local();
        Local array2 = e.make_local();
        Local loopvar = e.make_local(Type.INT_TYPE);
        Label loopbody = e.make_label();
        Label checkloop = e.make_label();
        e.store_local(array1);
        e.store_local(array2);
        e.push(0);
        e.store_local(loopvar);
        e.goTo(checkloop);
        e.mark(loopbody);
        e.load_local(array1);
        e.load_local(loopvar);
        e.array_load(componentType);
        e.load_local(array2);
        e.load_local(loopvar);
        e.array_load(componentType);
        callback.processElement(componentType);
        e.iinc(loopvar, 1);
        e.mark(checkloop);
        e.load_local(loopvar);
        e.load_local(array1);
        e.arraylength();
        e.if_icmp(155, loopbody);
    }

    public static void string_switch(CodeEmitter e, String[] strings, int switchStyle, ObjectSwitchCallback callback) {
        try {
            switch (switchStyle) {
                case 0: {
                    EmitUtils.string_switch_trie(e, strings, callback);
                    break;
                }
                case 1: {
                    EmitUtils.string_switch_hash(e, strings, callback, false);
                    break;
                }
                case 2: {
                    EmitUtils.string_switch_hash(e, strings, callback, true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown switch style " + switchStyle);
                }
            }
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CodeGenerationException(ex);
        }
    }

    private static void string_switch_trie(final CodeEmitter e, String[] strings, final ObjectSwitchCallback callback) throws Exception {
        final Label def = e.make_label();
        final Label end2 = e.make_label();
        final Map buckets = CollectionUtils.bucket(Arrays.asList(strings), value2 -> ((String)value2).length());
        e.dup();
        e.invoke_virtual(Constants.TYPE_STRING, STRING_LENGTH);
        e.process_switch(EmitUtils.getSwitchKeys(buckets), new ProcessSwitchCallback(){

            @Override
            public void processCase(int key2, Label ignore_end) throws Exception {
                List bucket = (List)buckets.get(key2);
                EmitUtils.stringSwitchHelper(e, bucket, callback, def, end2, 0);
            }

            @Override
            public void processDefault() {
                e.goTo(def);
            }
        });
        e.mark(def);
        e.pop();
        callback.processDefault();
        e.mark(end2);
    }

    private static void stringSwitchHelper(final CodeEmitter e, List strings, final ObjectSwitchCallback callback, final Label def, final Label end2, final int index2) throws Exception {
        final int len = ((String)strings.get(0)).length();
        final Map buckets = CollectionUtils.bucket(strings, value2 -> Character.valueOf(((String)value2).charAt(index2)));
        e.dup();
        e.push(index2);
        e.invoke_virtual(Constants.TYPE_STRING, STRING_CHAR_AT);
        e.process_switch(EmitUtils.getSwitchKeys(buckets), new ProcessSwitchCallback(){

            @Override
            public void processCase(int key2, Label ignore_end) throws Exception {
                List bucket = (List)buckets.get(key2);
                if (index2 + 1 == len) {
                    e.pop();
                    callback.processCase(bucket.get(0), end2);
                } else {
                    EmitUtils.stringSwitchHelper(e, bucket, callback, def, end2, index2 + 1);
                }
            }

            @Override
            public void processDefault() {
                e.goTo(def);
            }
        });
    }

    static int[] getSwitchKeys(Map buckets) {
        int[] keys2 = new int[buckets.size()];
        int index2 = 0;
        Iterator it = buckets.keySet().iterator();
        while (it.hasNext()) {
            keys2[index2++] = (Integer)it.next();
        }
        Arrays.sort(keys2);
        return keys2;
    }

    private static void string_switch_hash(final CodeEmitter e, String[] strings, final ObjectSwitchCallback callback, final boolean skipEquals) throws Exception {
        final Map buckets = CollectionUtils.bucket(Arrays.asList(strings), value2 -> value2.hashCode());
        final Label def = e.make_label();
        final Label end2 = e.make_label();
        e.dup();
        e.invoke_virtual(Constants.TYPE_OBJECT, HASH_CODE);
        e.process_switch(EmitUtils.getSwitchKeys(buckets), new ProcessSwitchCallback(){

            @Override
            public void processCase(int key2, Label ignore_end) throws Exception {
                List bucket = (List)buckets.get(key2);
                Label next2 = null;
                if (skipEquals && bucket.size() == 1) {
                    if (skipEquals) {
                        e.pop();
                    }
                    callback.processCase(bucket.get(0), end2);
                } else {
                    Iterator it = bucket.iterator();
                    while (it.hasNext()) {
                        String string2 = (String)it.next();
                        if (next2 != null) {
                            e.mark(next2);
                        }
                        if (it.hasNext()) {
                            e.dup();
                        }
                        e.push(string2);
                        e.invoke_virtual(Constants.TYPE_OBJECT, EQUALS);
                        if (it.hasNext()) {
                            next2 = e.make_label();
                            e.if_jump(153, next2);
                            e.pop();
                        } else {
                            e.if_jump(153, def);
                        }
                        callback.processCase(string2, end2);
                    }
                }
            }

            @Override
            public void processDefault() {
                e.pop();
            }
        });
        e.mark(def);
        callback.processDefault();
        e.mark(end2);
    }

    public static void load_class_this(CodeEmitter e) {
        EmitUtils.load_class_helper(e, e.getClassEmitter().getClassType());
    }

    public static void load_class(CodeEmitter e, Type type2) {
        if (TypeUtils.isPrimitive(type2)) {
            if (type2 == Type.VOID_TYPE) {
                throw new IllegalArgumentException("cannot load void type");
            }
            e.getstatic(TypeUtils.getBoxedType(type2), "TYPE", Constants.TYPE_CLASS);
        } else {
            EmitUtils.load_class_helper(e, type2);
        }
    }

    private static void load_class_helper(CodeEmitter e, Type type2) {
        if (e.isStaticHook()) {
            e.push(TypeUtils.emulateClassGetName(type2));
            e.invoke_static(Constants.TYPE_CLASS, FOR_NAME);
        } else {
            String typeName;
            String fieldName;
            ClassEmitter ce = e.getClassEmitter();
            if (!ce.isFieldDeclared(fieldName = "CGLIB$load_class$" + TypeUtils.escapeType(typeName = TypeUtils.emulateClassGetName(type2)))) {
                ce.declare_field(26, fieldName, Constants.TYPE_CLASS, null);
                CodeEmitter hook = ce.getStaticHook();
                hook.push(typeName);
                hook.invoke_static(Constants.TYPE_CLASS, FOR_NAME);
                hook.putstatic(ce.getClassType(), fieldName, Constants.TYPE_CLASS);
            }
            e.getfield(fieldName);
        }
    }

    public static void push_array(CodeEmitter e, Object[] array2) {
        e.push(array2.length);
        e.newarray(Type.getType(EmitUtils.remapComponentType((Class)array2.getClass().componentType())));
        for (int i2 = 0; i2 < array2.length; ++i2) {
            e.dup();
            e.push(i2);
            EmitUtils.push_object(e, array2[i2]);
            e.aastore();
        }
    }

    private static Class remapComponentType(Class componentType) {
        if (componentType.equals(Type.class)) {
            return Class.class;
        }
        return componentType;
    }

    public static void push_object(CodeEmitter e, Object obj) {
        if (obj == null) {
            e.aconst_null();
        } else if (obj.getClass().isArray()) {
            EmitUtils.push_array(e, (Object[])obj);
        } else if (obj instanceof String) {
            String text = (String)obj;
            e.push(text);
        } else if (obj instanceof Type) {
            Type type2 = (Type)obj;
            EmitUtils.load_class(e, type2);
        } else if (obj instanceof Class) {
            Class clazz = (Class)obj;
            EmitUtils.load_class(e, Type.getType(clazz));
        } else if (obj instanceof BigInteger) {
            e.new_instance(Constants.TYPE_BIG_INTEGER);
            e.dup();
            e.push(obj.toString());
            e.invoke_constructor(Constants.TYPE_BIG_INTEGER);
        } else if (obj instanceof BigDecimal) {
            e.new_instance(Constants.TYPE_BIG_DECIMAL);
            e.dup();
            e.push(obj.toString());
            e.invoke_constructor(Constants.TYPE_BIG_DECIMAL);
        } else {
            throw new IllegalArgumentException("unknown type: " + obj.getClass());
        }
    }

    @Deprecated
    public static void hash_code(CodeEmitter e, Type type2, int multiplier, Customizer customizer2) {
        EmitUtils.hash_code(e, type2, multiplier, CustomizerRegistry.singleton(customizer2));
    }

    public static void hash_code(CodeEmitter e, Type type2, int multiplier, CustomizerRegistry registry) {
        if (TypeUtils.isArray(type2)) {
            EmitUtils.hash_array(e, type2, multiplier, registry);
        } else {
            e.swap(Type.INT_TYPE, type2);
            e.push(multiplier);
            e.math(104, Type.INT_TYPE);
            e.swap(type2, Type.INT_TYPE);
            if (TypeUtils.isPrimitive(type2)) {
                EmitUtils.hash_primitive(e, type2);
            } else {
                EmitUtils.hash_object(e, type2, registry);
            }
            e.math(96, Type.INT_TYPE);
        }
    }

    private static void hash_array(CodeEmitter e, Type type2, int multiplier, CustomizerRegistry registry) {
        Label skip2 = e.make_label();
        Label end2 = e.make_label();
        e.dup();
        e.ifnull(skip2);
        EmitUtils.process_array(e, type2, type1 -> EmitUtils.hash_code(e, type1, multiplier, registry));
        e.goTo(end2);
        e.mark(skip2);
        e.pop();
        e.mark(end2);
    }

    private static void hash_object(CodeEmitter e, Type type2, CustomizerRegistry registry) {
        Label skip2 = e.make_label();
        Label end2 = e.make_label();
        e.dup();
        e.ifnull(skip2);
        boolean customHashCode = false;
        for (HashCodeCustomizer hashCodeCustomizer : registry.get(HashCodeCustomizer.class)) {
            if (!hashCodeCustomizer.customize(e, type2)) continue;
            customHashCode = true;
            break;
        }
        if (!customHashCode) {
            for (Customizer customizer2 : registry.get(Customizer.class)) {
                customizer2.customize(e, type2);
            }
            e.invoke_virtual(Constants.TYPE_OBJECT, HASH_CODE);
        }
        e.goTo(end2);
        e.mark(skip2);
        e.pop();
        e.push(0);
        e.mark(end2);
    }

    private static void hash_primitive(CodeEmitter e, Type type2) {
        switch (type2.getSort()) {
            case 1: {
                e.push(1);
                e.math(130, Type.INT_TYPE);
                break;
            }
            case 6: {
                e.invoke_static(Constants.TYPE_FLOAT, FLOAT_TO_INT_BITS);
                break;
            }
            case 8: {
                e.invoke_static(Constants.TYPE_DOUBLE, DOUBLE_TO_LONG_BITS);
            }
            case 7: {
                EmitUtils.hash_long(e);
            }
        }
    }

    private static void hash_long(CodeEmitter e) {
        e.dup2();
        e.push(32);
        e.math(124, Type.LONG_TYPE);
        e.math(130, Type.LONG_TYPE);
        e.cast_numeric(Type.LONG_TYPE, Type.INT_TYPE);
    }

    @Deprecated
    public static void not_equals(CodeEmitter e, Type type2, Label notEquals, Customizer customizer2) {
        EmitUtils.not_equals(e, type2, notEquals, CustomizerRegistry.singleton(customizer2));
    }

    public static void not_equals(final CodeEmitter e, Type type2, final Label notEquals, final CustomizerRegistry registry) {
        new ProcessArrayCallback(){

            @Override
            public void processElement(Type type2) {
                EmitUtils.not_equals_helper(e, type2, notEquals, registry, this);
            }
        }.processElement(type2);
    }

    private static void not_equals_helper(CodeEmitter e, Type type2, Label notEquals, CustomizerRegistry registry, ProcessArrayCallback callback) {
        if (TypeUtils.isPrimitive(type2)) {
            e.if_cmp(type2, 154, notEquals);
        } else {
            Label end2 = e.make_label();
            EmitUtils.nullcmp(e, notEquals, end2);
            if (TypeUtils.isArray(type2)) {
                Label checkContents = e.make_label();
                e.dup2();
                e.arraylength();
                e.swap();
                e.arraylength();
                e.if_icmp(153, checkContents);
                e.pop2();
                e.goTo(notEquals);
                e.mark(checkContents);
                EmitUtils.process_arrays(e, type2, callback);
            } else {
                List<Customizer> customizers = registry.get(Customizer.class);
                if (!customizers.isEmpty()) {
                    for (Customizer customizer2 : customizers) {
                        customizer2.customize(e, type2);
                    }
                    e.swap();
                    for (Customizer customizer2 : customizers) {
                        customizer2.customize(e, type2);
                    }
                }
                e.invoke_virtual(Constants.TYPE_OBJECT, EQUALS);
                e.if_jump(153, notEquals);
            }
            e.mark(end2);
        }
    }

    private static void nullcmp(CodeEmitter e, Label oneNull, Label bothNull) {
        e.dup2();
        Label nonNull = e.make_label();
        Label oneNullHelper = e.make_label();
        Label end2 = e.make_label();
        e.ifnonnull(nonNull);
        e.ifnonnull(oneNullHelper);
        e.pop2();
        e.goTo(bothNull);
        e.mark(nonNull);
        e.ifnull(oneNullHelper);
        e.goTo(end2);
        e.mark(oneNullHelper);
        e.pop2();
        e.goTo(oneNull);
        e.mark(end2);
    }

    @Deprecated
    public static void append_string(CodeEmitter e, Type type2, ArrayDelimiters delims, Customizer customizer2) {
        EmitUtils.append_string(e, type2, delims, CustomizerRegistry.singleton(customizer2));
    }

    public static void append_string(final CodeEmitter e, Type type2, ArrayDelimiters delims, final CustomizerRegistry registry) {
        final ArrayDelimiters d = delims != null ? delims : DEFAULT_DELIMITERS;
        ProcessArrayCallback callback = new ProcessArrayCallback(){

            @Override
            public void processElement(Type type2) {
                EmitUtils.append_string_helper(e, type2, d, registry, this);
                e.push(d.inside);
                e.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_STRING);
            }
        };
        EmitUtils.append_string_helper(e, type2, d, registry, callback);
    }

    private static void append_string_helper(CodeEmitter e, Type type2, ArrayDelimiters delims, CustomizerRegistry registry, ProcessArrayCallback callback) {
        Label skip2 = e.make_label();
        Label end2 = e.make_label();
        if (TypeUtils.isPrimitive(type2)) {
            switch (type2.getSort()) {
                case 3: 
                case 4: 
                case 5: {
                    e.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_INT);
                    break;
                }
                case 8: {
                    e.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_DOUBLE);
                    break;
                }
                case 6: {
                    e.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_FLOAT);
                    break;
                }
                case 7: {
                    e.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_LONG);
                    break;
                }
                case 1: {
                    e.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_BOOLEAN);
                    break;
                }
                case 2: {
                    e.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_CHAR);
                }
            }
        } else if (TypeUtils.isArray(type2)) {
            e.dup();
            e.ifnull(skip2);
            e.swap();
            if (delims != null && delims.before != null && !"".equals(delims.before)) {
                e.push(delims.before);
                e.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_STRING);
                e.swap();
            }
            EmitUtils.process_array(e, type2, callback);
            EmitUtils.shrinkStringBuffer(e, 2);
            if (delims != null && delims.after != null && !"".equals(delims.after)) {
                e.push(delims.after);
                e.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_STRING);
            }
        } else {
            e.dup();
            e.ifnull(skip2);
            for (Customizer customizer2 : registry.get(Customizer.class)) {
                customizer2.customize(e, type2);
            }
            e.invoke_virtual(Constants.TYPE_OBJECT, TO_STRING);
            e.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_STRING);
        }
        e.goTo(end2);
        e.mark(skip2);
        e.pop();
        e.push("null");
        e.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_STRING);
        e.mark(end2);
    }

    private static void shrinkStringBuffer(CodeEmitter e, int amt) {
        e.dup();
        e.dup();
        e.invoke_virtual(Constants.TYPE_STRING_BUFFER, LENGTH);
        e.push(amt);
        e.math(100, Type.INT_TYPE);
        e.invoke_virtual(Constants.TYPE_STRING_BUFFER, SET_LENGTH);
    }

    public static void load_method(CodeEmitter e, MethodInfo method2) {
        EmitUtils.load_class(e, method2.getClassInfo().getType());
        e.push(method2.getSignature().getName());
        EmitUtils.push_object(e, method2.getSignature().getArgumentTypes());
        e.invoke_virtual(Constants.TYPE_CLASS, GET_DECLARED_METHOD);
    }

    public static void method_switch(CodeEmitter e, List methods2, ObjectSwitchCallback callback) {
        EmitUtils.member_switch_helper(e, methods2, callback, true);
    }

    public static void constructor_switch(CodeEmitter e, List constructors2, ObjectSwitchCallback callback) {
        EmitUtils.member_switch_helper(e, constructors2, callback, false);
    }

    private static void member_switch_helper(final CodeEmitter e, List members2, final ObjectSwitchCallback callback, boolean useName) {
        try {
            HashMap cache = new HashMap();
            final ParameterTyper cached = member -> {
                Type[] types = (Type[])cache.get(member);
                if (types == null) {
                    types = member.getSignature().getArgumentTypes();
                    cache.put(member, types);
                }
                return types;
            };
            final Label def = e.make_label();
            final Label end2 = e.make_label();
            if (useName) {
                e.swap();
                final Map buckets = CollectionUtils.bucket(members2, value2 -> ((MethodInfo)value2).getSignature().getName());
                String[] names2 = buckets.keySet().toArray(new String[buckets.size()]);
                EmitUtils.string_switch(e, names2, 1, new ObjectSwitchCallback(){

                    @Override
                    public void processCase(Object key2, Label dontUseEnd) throws Exception {
                        EmitUtils.member_helper_size(e, (List)buckets.get(key2), callback, cached, def, end2);
                    }

                    @Override
                    public void processDefault() throws Exception {
                        e.goTo(def);
                    }
                });
            } else {
                EmitUtils.member_helper_size(e, members2, callback, cached, def, end2);
            }
            e.mark(def);
            e.pop();
            callback.processDefault();
            e.mark(end2);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CodeGenerationException(ex);
        }
    }

    private static void member_helper_size(final CodeEmitter e, List members2, final ObjectSwitchCallback callback, final ParameterTyper typer, final Label def, final Label end2) throws Exception {
        final Map buckets = CollectionUtils.bucket(members2, value2 -> typer.getParameterTypes((MethodInfo)value2).length);
        e.dup();
        e.arraylength();
        e.process_switch(EmitUtils.getSwitchKeys(buckets), new ProcessSwitchCallback(){

            @Override
            public void processCase(int key2, Label dontUseEnd) throws Exception {
                List bucket = (List)buckets.get(key2);
                EmitUtils.member_helper_type(e, bucket, callback, typer, def, end2, new BitSet());
            }

            @Override
            public void processDefault() throws Exception {
                e.goTo(def);
            }
        });
    }

    private static void member_helper_type(final CodeEmitter e, List members2, final ObjectSwitchCallback callback, final ParameterTyper typer, final Label def, final Label end2, final BitSet checked) throws Exception {
        if (members2.size() == 1) {
            MethodInfo member = (MethodInfo)members2.get(0);
            Type[] types = typer.getParameterTypes(member);
            for (int i2 = 0; i2 < types.length; ++i2) {
                if (checked != null && checked.get(i2)) continue;
                e.dup();
                e.aaload(i2);
                e.invoke_virtual(Constants.TYPE_CLASS, GET_NAME);
                e.push(TypeUtils.emulateClassGetName(types[i2]));
                e.invoke_virtual(Constants.TYPE_OBJECT, EQUALS);
                e.if_jump(153, def);
            }
            e.pop();
            callback.processCase(member, end2);
        } else {
            Type[] example = typer.getParameterTypes((MethodInfo)members2.get(0));
            Map buckets = null;
            int index2 = -1;
            for (int i3 = 0; i3 < example.length; ++i3) {
                int j = i3;
                Map test2 = CollectionUtils.bucket(members2, value2 -> TypeUtils.emulateClassGetName(typer.getParameterTypes((MethodInfo)value2)[j]));
                if (buckets != null && test2.size() <= buckets.size()) continue;
                buckets = test2;
                index2 = i3;
            }
            if (buckets == null || buckets.size() == 1) {
                e.goTo(def);
            } else {
                checked.set(index2);
                e.dup();
                e.aaload(index2);
                e.invoke_virtual(Constants.TYPE_CLASS, GET_NAME);
                final Map fbuckets = buckets;
                String[] names2 = buckets.keySet().toArray(new String[buckets.size()]);
                EmitUtils.string_switch(e, names2, 1, new ObjectSwitchCallback(){

                    @Override
                    public void processCase(Object key2, Label dontUseEnd) throws Exception {
                        EmitUtils.member_helper_type(e, (List)fbuckets.get(key2), callback, typer, def, end2, checked);
                    }

                    @Override
                    public void processDefault() throws Exception {
                        e.goTo(def);
                    }
                });
            }
        }
    }

    public static void wrap_throwable(Block block, Type wrapper) {
        CodeEmitter e = block.getCodeEmitter();
        e.catch_exception(block, Constants.TYPE_THROWABLE);
        e.new_instance(wrapper);
        e.dup_x1();
        e.swap();
        e.invoke_constructor(wrapper, CSTRUCT_THROWABLE);
        e.athrow();
    }

    public static void add_properties(ClassEmitter ce, String[] names2, Type[] types) {
        for (int i2 = 0; i2 < names2.length; ++i2) {
            String fieldName = "$cglib_prop_" + names2[i2];
            ce.declare_field(2, fieldName, types[i2], null);
            EmitUtils.add_property(ce, names2[i2], types[i2], fieldName);
        }
    }

    public static void add_property(ClassEmitter ce, String name2, Type type2, String fieldName) {
        String property = TypeUtils.upperFirst(name2);
        CodeEmitter e = ce.begin_method(1, new Signature("get" + property, type2, Constants.TYPES_EMPTY), null);
        e.load_this();
        e.getfield(fieldName);
        e.return_value();
        e.end_method();
        e = ce.begin_method(1, new Signature("set" + property, Type.VOID_TYPE, new Type[]{type2}), null);
        e.load_this();
        e.load_arg(0);
        e.putfield(fieldName);
        e.return_value();
        e.end_method();
    }

    public static void wrap_undeclared_throwable(CodeEmitter e, Block handler, Type[] exceptions, Type wrapper) {
        boolean needThrow;
        Set<Object> set2;
        Set<Object> set3 = set2 = exceptions == null ? Collections.EMPTY_SET : new HashSet<Type>(Arrays.asList(exceptions));
        if (set2.contains(Constants.TYPE_THROWABLE)) {
            return;
        }
        boolean bl = needThrow = exceptions != null;
        if (!set2.contains(Constants.TYPE_RUNTIME_EXCEPTION)) {
            e.catch_exception(handler, Constants.TYPE_RUNTIME_EXCEPTION);
            needThrow = true;
        }
        if (!set2.contains(Constants.TYPE_ERROR)) {
            e.catch_exception(handler, Constants.TYPE_ERROR);
            needThrow = true;
        }
        if (exceptions != null) {
            for (Type exception2 : exceptions) {
                e.catch_exception(handler, exception2);
            }
        }
        if (needThrow) {
            e.athrow();
        }
        e.catch_exception(handler, Constants.TYPE_THROWABLE);
        e.new_instance(wrapper);
        e.dup_x1();
        e.swap();
        e.invoke_constructor(wrapper, CSTRUCT_THROWABLE);
        e.athrow();
    }

    public static CodeEmitter begin_method(ClassEmitter e, MethodInfo method2) {
        return EmitUtils.begin_method(e, method2, method2.getModifiers());
    }

    public static CodeEmitter begin_method(ClassEmitter e, MethodInfo method2, int access) {
        return e.begin_method(access, method2.getSignature(), method2.getExceptionTypes());
    }

    public static class ArrayDelimiters {
        private String before;
        private String inside;
        private String after;

        public ArrayDelimiters(String before, String inside, String after) {
            this.before = before;
            this.inside = inside;
            this.after = after;
        }
    }

    private static interface ParameterTyper {
        public Type[] getParameterTypes(MethodInfo var1);
    }
}

