/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.ClassWriter;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.core.Constants;

public class DebuggingClassWriter
extends ClassVisitor {
    public static final String DEBUG_LOCATION_PROPERTY = "cglib.debugLocation";
    private static String debugLocation = System.getProperty("cglib.debugLocation");
    private static Constructor traceCtor;
    private String className;
    private String superName;

    public DebuggingClassWriter(int flags2) {
        super(Constants.ASM_API, new ClassWriter(flags2));
    }

    @Override
    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces2) {
        this.className = name2.replace('/', '.');
        this.superName = superName.replace('/', '.');
        super.visit(version, access, name2, signature, superName, interfaces2);
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperName() {
        return this.superName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() {
        byte[] b2;
        block10: {
            b2 = ((ClassWriter)this.cv).toByteArray();
            if (debugLocation != null) {
                String dirs = this.className.replace('.', File.separatorChar);
                try {
                    new File(debugLocation + File.separatorChar + dirs).getParentFile().mkdirs();
                    File file2 = new File(new File(debugLocation), dirs + ".class");
                    try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file2));){
                        ((OutputStream)out).write(b2);
                    }
                    if (traceCtor == null) break block10;
                    file2 = new File(new File(debugLocation), dirs + ".asm");
                    out = new BufferedOutputStream(new FileOutputStream(file2));
                    try {
                        ClassReader cr = new ClassReader(b2);
                        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out));
                        ClassVisitor tcv = (ClassVisitor)traceCtor.newInstance(null, pw);
                        cr.accept(tcv, 0);
                        pw.flush();
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
                catch (Exception e) {
                    throw new CodeGenerationException(e);
                }
            }
        }
        return b2;
    }

    static {
        if (debugLocation != null) {
            System.err.println("CGLIB debugging enabled, writing to '" + debugLocation + "'");
            try {
                Class<?> clazz = Class.forName("org.springframework.asm.util.TraceClassVisitor");
                traceCtor = clazz.getConstructor(ClassVisitor.class, PrintWriter.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

