/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.cglib.core.Predicate;
import org.springframework.cglib.core.Transformer;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static Map bucket(Collection c, Transformer t) {
        HashMap buckets = new HashMap();
        for (Object value2 : c) {
            Object key2 = t.transform(value2);
            LinkedList bucket = (LinkedList)buckets.get(key2);
            if (bucket == null) {
                bucket = new LinkedList();
                buckets.put(key2, bucket);
            }
            bucket.add(value2);
        }
        return buckets;
    }

    public static void reverse(Map source2, Map target2) {
        for (Object key2 : source2.keySet()) {
            target2.put(source2.get(key2), key2);
        }
    }

    public static Collection filter(Collection c, Predicate p2) {
        c.removeIf(o -> !p2.evaluate(o));
        return c;
    }

    public static List transform(Collection c, Transformer t) {
        ArrayList<Object> result2 = new ArrayList<Object>(c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            result2.add(t.transform(it.next()));
        }
        return result2;
    }

    public static Map getIndexMap(List list2) {
        HashMap indexes2 = new HashMap();
        int index2 = 0;
        Iterator it = list2.iterator();
        while (it.hasNext()) {
            indexes2.put(it.next(), index2++);
        }
        return indexes2;
    }
}

