/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.beans;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.asm.ClassVisitor;
import org.springframework.cglib.beans.BeanMapEmitter;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.KeyFactory;
import org.springframework.cglib.core.ReflectUtils;

public abstract class BeanMap
implements Map {
    public static final int REQUIRE_GETTER = 1;
    public static final int REQUIRE_SETTER = 2;
    protected Object bean;

    public static BeanMap create(Object bean2) {
        Generator gen = new Generator();
        gen.setBean(bean2);
        return gen.create();
    }

    public abstract BeanMap newInstance(Object var1);

    public abstract Class getPropertyType(String var1);

    protected BeanMap() {
    }

    protected BeanMap(Object bean2) {
        this.setBean(bean2);
    }

    public Object get(Object key2) {
        return this.get(this.bean, key2);
    }

    public Object put(Object key2, Object value2) {
        return this.put(this.bean, key2, value2);
    }

    public abstract Object get(Object var1, Object var2);

    public abstract Object put(Object var1, Object var2, Object var3);

    public void setBean(Object bean2) {
        this.bean = bean2;
    }

    public Object getBean() {
        return this.bean;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.keySet().contains(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Object v = this.get(it.next());
            if ((value2 != null || v != null) && (value2 == null || !value2.equals(v))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object remove(Object key2) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
        for (Object key2 : t.keySet()) {
            this.put(key2, t.get(key2));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        if (this.size() != other.size()) {
            return false;
        }
        for (Object key2 : this.keySet()) {
            Object v2;
            if (!other.containsKey(key2)) {
                return false;
            }
            Object v1 = this.get(key2);
            if (Objects.equals(v1, v2 = other.get(key2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int code = 0;
        for (Object key2 : this.keySet()) {
            Object value2 = this.get(key2);
            code += (key2 == null ? 0 : key2.hashCode()) ^ (value2 == null ? 0 : value2.hashCode());
        }
        return code;
    }

    public Set entrySet() {
        HashMap copy2 = new HashMap();
        for (Object key2 : this.keySet()) {
            copy2.put(key2, this.get(key2));
        }
        return Collections.unmodifiableMap(copy2).entrySet();
    }

    public Collection values() {
        Set keys2 = this.keySet();
        ArrayList<Object> values2 = new ArrayList<Object>(keys2.size());
        Iterator it = keys2.iterator();
        while (it.hasNext()) {
            values2.add(this.get(it.next()));
        }
        return Collections.unmodifiableCollection(values2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Object key2 = it.next();
            sb.append(key2);
            sb.append('=');
            sb.append(this.get(key2));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(BeanMap.class.getName());
        private static final BeanMapKey KEY_FACTORY = (BeanMapKey)((Object)KeyFactory.create(BeanMapKey.class, KeyFactory.CLASS_BY_NAME));
        private Object bean;
        private Class beanClass;
        private int require;

        public Generator() {
            super(SOURCE);
        }

        public void setBean(Object bean2) {
            this.bean = bean2;
            if (bean2 != null) {
                this.beanClass = bean2.getClass();
                this.setContextClass(this.beanClass);
            }
        }

        public void setBeanClass(Class beanClass) {
            this.beanClass = beanClass;
        }

        public void setRequire(int require2) {
            this.require = require2;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.beanClass.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectUtils.getProtectionDomain(this.beanClass);
        }

        public BeanMap create() {
            if (this.beanClass == null) {
                throw new IllegalArgumentException("Class of bean unknown");
            }
            this.setNamePrefix(this.beanClass.getName());
            return (BeanMap)super.create(KEY_FACTORY.newInstance(this.beanClass, this.require));
        }

        @Override
        public void generateClass(ClassVisitor v) throws Exception {
            new BeanMapEmitter(v, this.getClassName(), this.beanClass, this.require);
        }

        @Override
        protected Object firstInstance(Class type2) {
            return ((BeanMap)ReflectUtils.newInstance(type2)).newInstance(this.bean);
        }

        @Override
        protected Object nextInstance(Object instance) {
            return ((BeanMap)instance).newInstance(this.bean);
        }

        static interface BeanMapKey {
            public Object newInstance(Class var1, int var2);
        }
    }
}

