/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.beans;

import java.beans.PropertyDescriptor;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Type;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.KeyFactory;
import org.springframework.cglib.core.ReflectUtils;

public class BeanGenerator
extends AbstractClassGenerator {
    private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(BeanGenerator.class.getName());
    private static final BeanGeneratorKey KEY_FACTORY = (BeanGeneratorKey)((Object)KeyFactory.create(BeanGeneratorKey.class));
    private Class superclass;
    private Map props = new HashMap();
    private boolean classOnly;

    public BeanGenerator() {
        super(SOURCE);
    }

    public void setSuperclass(Class superclass2) {
        if (superclass2 != null && superclass2.equals(Object.class)) {
            superclass2 = null;
        }
        this.superclass = superclass2;
        this.setContextClass(superclass2);
    }

    public void addProperty(String name2, Class type2) {
        if (this.props.containsKey(name2)) {
            throw new IllegalArgumentException("Duplicate property name \"" + name2 + "\"");
        }
        this.props.put(name2, Type.getType(type2));
    }

    @Override
    protected ClassLoader getDefaultClassLoader() {
        if (this.superclass != null) {
            return this.superclass.getClassLoader();
        }
        return null;
    }

    @Override
    protected ProtectionDomain getProtectionDomain() {
        return ReflectUtils.getProtectionDomain(this.superclass);
    }

    public Object create() {
        this.classOnly = false;
        return this.createHelper();
    }

    public Object createClass() {
        this.classOnly = true;
        return this.createHelper();
    }

    private Object createHelper() {
        if (this.superclass != null) {
            this.setNamePrefix(this.superclass.getName());
        }
        String superName = this.superclass != null ? this.superclass.getName() : "java.lang.Object";
        Object key2 = KEY_FACTORY.newInstance(superName, this.props);
        return super.create(key2);
    }

    @Override
    public void generateClass(ClassVisitor v) throws Exception {
        int size2 = this.props.size();
        String[] names2 = this.props.keySet().toArray(new String[size2]);
        Type[] types = new Type[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            types[i2] = (Type)this.props.get(names2[i2]);
        }
        ClassEmitter ce = new ClassEmitter(v);
        ce.begin_class(52, 1, this.getClassName(), this.superclass != null ? Type.getType(this.superclass) : Constants.TYPE_OBJECT, null, null);
        EmitUtils.null_constructor(ce);
        EmitUtils.add_properties(ce, names2, types);
        ce.end_class();
    }

    @Override
    protected Object firstInstance(Class type2) {
        if (this.classOnly) {
            return type2;
        }
        return ReflectUtils.newInstance(type2);
    }

    @Override
    protected Object nextInstance(Object instance) {
        Class clazz;
        Class protoclass;
        Class clazz2 = protoclass = instance instanceof Class ? (clazz = (Class)instance) : instance.getClass();
        if (this.classOnly) {
            return protoclass;
        }
        return ReflectUtils.newInstance(protoclass);
    }

    public static void addProperties(BeanGenerator gen, Map props) {
        for (String name2 : props.keySet()) {
            gen.addProperty(name2, (Class)props.get(name2));
        }
    }

    public static void addProperties(BeanGenerator gen, Class type2) {
        BeanGenerator.addProperties(gen, ReflectUtils.getBeanProperties(type2));
    }

    public static void addProperties(BeanGenerator gen, PropertyDescriptor[] descriptors) {
        for (PropertyDescriptor descriptor : descriptors) {
            gen.addProperty(descriptor.getName(), descriptor.getPropertyType());
        }
    }

    static interface BeanGeneratorKey {
        public Object newInstance(String var1, Map var2);
    }
}

