/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.support;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.springframework.cache.Cache;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class NoOpCache
implements Cache {
    private final String name;

    public NoOpCache(String name2) {
        Assert.notNull((Object)name2, "Cache name must not be null");
        this.name = name2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getNativeCache() {
        return this;
    }

    @Override
    @Nullable
    public Cache.ValueWrapper get(Object key2) {
        return null;
    }

    @Override
    @Nullable
    public <T> T get(Object key2, @Nullable Class<T> type2) {
        return null;
    }

    @Override
    @Nullable
    public <T> T get(Object key2, Callable<T> valueLoader) {
        try {
            return valueLoader.call();
        }
        catch (Exception ex) {
            throw new Cache.ValueRetrievalException(key2, valueLoader, ex);
        }
    }

    @Override
    @Nullable
    public CompletableFuture<?> retrieve(Object key2) {
        return null;
    }

    @Override
    public <T> CompletableFuture<T> retrieve(Object key2, Supplier<CompletableFuture<T>> valueLoader) {
        return valueLoader.get();
    }

    @Override
    public void put(Object key2, @Nullable Object value2) {
    }

    @Override
    @Nullable
    public Cache.ValueWrapper putIfAbsent(Object key2, @Nullable Object value2) {
        return null;
    }

    @Override
    public void evict(Object key2) {
    }

    @Override
    public boolean evictIfPresent(Object key2) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean invalidate() {
        return false;
    }
}

