/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.support;

import org.springframework.cache.Cache;
import org.springframework.cache.support.NullValue;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.lang.Nullable;

public abstract class AbstractValueAdaptingCache
implements Cache {
    private final boolean allowNullValues;

    protected AbstractValueAdaptingCache(boolean allowNullValues) {
        this.allowNullValues = allowNullValues;
    }

    public final boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    @Override
    @Nullable
    public Cache.ValueWrapper get(Object key2) {
        return this.toValueWrapper(this.lookup(key2));
    }

    @Override
    @Nullable
    public <T> T get(Object key2, @Nullable Class<T> type2) {
        Object value2 = this.fromStoreValue(this.lookup(key2));
        if (value2 != null && type2 != null && !type2.isInstance(value2)) {
            throw new IllegalStateException("Cached value is not of required type [" + type2.getName() + "]: " + value2);
        }
        return (T)value2;
    }

    @Nullable
    protected abstract Object lookup(Object var1);

    @Nullable
    protected Object fromStoreValue(@Nullable Object storeValue) {
        if (this.allowNullValues && storeValue == NullValue.INSTANCE) {
            return null;
        }
        return storeValue;
    }

    protected Object toStoreValue(@Nullable Object userValue) {
        if (userValue == null) {
            if (this.allowNullValues) {
                return NullValue.INSTANCE;
            }
            throw new IllegalArgumentException("Cache '" + this.getName() + "' is configured to not allow null values but null was provided");
        }
        return userValue;
    }

    @Nullable
    protected Cache.ValueWrapper toValueWrapper(@Nullable Object storeValue) {
        return storeValue != null ? new SimpleValueWrapper(this.fromStoreValue(storeValue)) : null;
    }
}

