/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class LoggingCacheErrorHandler
implements CacheErrorHandler {
    private final Log logger;
    private final boolean logStackTraces;

    public LoggingCacheErrorHandler() {
        this(false);
    }

    public LoggingCacheErrorHandler(boolean logStackTraces) {
        this(LogFactory.getLog(LoggingCacheErrorHandler.class), logStackTraces);
    }

    public LoggingCacheErrorHandler(Log logger, boolean logStackTraces) {
        Assert.notNull((Object)logger, "'logger' must not be null");
        this.logger = logger;
        this.logStackTraces = logStackTraces;
    }

    public LoggingCacheErrorHandler(String loggerName, boolean logStackTraces) {
        Assert.notNull((Object)loggerName, "'loggerName' must not be null");
        this.logger = LogFactory.getLog(loggerName);
        this.logStackTraces = logStackTraces;
    }

    @Override
    public void handleCacheGetError(RuntimeException exception2, Cache cache, Object key2) {
        this.logCacheError(() -> String.format("Cache '%s' failed to get entry with key '%s'", cache.getName(), key2), exception2);
    }

    @Override
    public void handleCachePutError(RuntimeException exception2, Cache cache, Object key2, @Nullable Object value2) {
        this.logCacheError(() -> String.format("Cache '%s' failed to put entry with key '%s'", cache.getName(), key2), exception2);
    }

    @Override
    public void handleCacheEvictError(RuntimeException exception2, Cache cache, Object key2) {
        this.logCacheError(() -> String.format("Cache '%s' failed to evict entry with key '%s'", cache.getName(), key2), exception2);
    }

    @Override
    public void handleCacheClearError(RuntimeException exception2, Cache cache) {
        this.logCacheError(() -> String.format("Cache '%s' failed to clear entries", cache.getName()), exception2);
    }

    protected final Log getLogger() {
        return this.logger;
    }

    protected final boolean isLogStackTraces() {
        return this.logStackTraces;
    }

    protected void logCacheError(Supplier<String> messageSupplier, RuntimeException exception2) {
        if (this.getLogger().isWarnEnabled()) {
            if (this.isLogStackTraces()) {
                this.getLogger().warn(messageSupplier.get(), exception2);
            } else {
                this.getLogger().warn(messageSupplier.get());
            }
        }
    }
}

