/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CacheOperationSource;
import org.springframework.core.MethodClassKey;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public abstract class AbstractFallbackCacheOperationSource
implements CacheOperationSource {
    private static final Collection<CacheOperation> NULL_CACHING_MARKER = Collections.emptyList();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<Object, Collection<CacheOperation>> operationCache = new ConcurrentHashMap<Object, Collection<CacheOperation>>(1024);

    @Override
    @Nullable
    public Collection<CacheOperation> getCacheOperations(Method method2, @Nullable Class<?> targetClass) {
        if (method2.getDeclaringClass() == Object.class) {
            return null;
        }
        Object cacheKey = this.getCacheKey(method2, targetClass);
        Collection<CacheOperation> cached = this.operationCache.get(cacheKey);
        if (cached != null) {
            return cached != NULL_CACHING_MARKER ? cached : null;
        }
        Collection<CacheOperation> cacheOps = this.computeCacheOperations(method2, targetClass);
        if (cacheOps != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Adding cacheable method '" + method2.getName() + "' with operations: " + cacheOps);
            }
            this.operationCache.put(cacheKey, cacheOps);
        } else {
            this.operationCache.put(cacheKey, NULL_CACHING_MARKER);
        }
        return cacheOps;
    }

    protected Object getCacheKey(Method method2, @Nullable Class<?> targetClass) {
        return new MethodClassKey(method2, targetClass);
    }

    @Nullable
    private Collection<CacheOperation> computeCacheOperations(Method method2, @Nullable Class<?> targetClass) {
        if (this.allowPublicMethodsOnly() && !Modifier.isPublic(method2.getModifiers())) {
            return null;
        }
        Method specificMethod = AopUtils.getMostSpecificMethod(method2, targetClass);
        Collection<CacheOperation> opDef = this.findCacheOperations(specificMethod);
        if (opDef != null) {
            return opDef;
        }
        opDef = this.findCacheOperations(specificMethod.getDeclaringClass());
        if (opDef != null && ClassUtils.isUserLevelMethod(method2)) {
            return opDef;
        }
        if (specificMethod != method2) {
            opDef = this.findCacheOperations(method2);
            if (opDef != null) {
                return opDef;
            }
            opDef = this.findCacheOperations(method2.getDeclaringClass());
            if (opDef != null && ClassUtils.isUserLevelMethod(method2)) {
                return opDef;
            }
        }
        return null;
    }

    @Nullable
    protected abstract Collection<CacheOperation> findCacheOperations(Class<?> var1);

    @Nullable
    protected abstract Collection<CacheOperation> findCacheOperations(Method var1);

    protected boolean allowPublicMethodsOnly() {
        return false;
    }
}

