/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;
import org.springframework.core.serializer.support.SerializationDelegate;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ConcurrentMapCache
extends AbstractValueAdaptingCache {
    private final String name;
    private final ConcurrentMap<Object, Object> store;
    @Nullable
    private final SerializationDelegate serialization;

    public ConcurrentMapCache(String name2) {
        this(name2, new ConcurrentHashMap<Object, Object>(256), true);
    }

    public ConcurrentMapCache(String name2, boolean allowNullValues) {
        this(name2, new ConcurrentHashMap<Object, Object>(256), allowNullValues);
    }

    public ConcurrentMapCache(String name2, ConcurrentMap<Object, Object> store, boolean allowNullValues) {
        this(name2, store, allowNullValues, null);
    }

    protected ConcurrentMapCache(String name2, ConcurrentMap<Object, Object> store, boolean allowNullValues, @Nullable SerializationDelegate serialization) {
        super(allowNullValues);
        Assert.notNull((Object)name2, "Name must not be null");
        Assert.notNull(store, "Store must not be null");
        this.name = name2;
        this.store = store;
        this.serialization = serialization;
    }

    public final boolean isStoreByValue() {
        return this.serialization != null;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final ConcurrentMap<Object, Object> getNativeCache() {
        return this.store;
    }

    @Override
    @Nullable
    protected Object lookup(Object key2) {
        return this.store.get(key2);
    }

    @Override
    @Nullable
    public <T> T get(Object key2, Callable<T> valueLoader) {
        return (T)this.fromStoreValue(this.store.computeIfAbsent(key2, k -> {
            try {
                return this.toStoreValue(valueLoader.call());
            }
            catch (Throwable ex) {
                throw new Cache.ValueRetrievalException(key2, valueLoader, ex);
            }
        }));
    }

    @Override
    @Nullable
    public CompletableFuture<?> retrieve(Object key2) {
        Object value2 = this.lookup(key2);
        return value2 != null ? CompletableFuture.completedFuture(this.isAllowNullValues() ? this.toValueWrapper(value2) : this.fromStoreValue(value2)) : null;
    }

    @Override
    public <T> CompletableFuture<T> retrieve(Object key2, Supplier<CompletableFuture<T>> valueLoader) {
        return CompletableFuture.supplyAsync(() -> this.fromStoreValue(this.store.computeIfAbsent(key2, arg_0 -> this.lambda$retrieve$1((Supplier)valueLoader, arg_0))));
    }

    @Override
    public void put(Object key2, @Nullable Object value2) {
        this.store.put(key2, this.toStoreValue(value2));
    }

    @Override
    @Nullable
    public Cache.ValueWrapper putIfAbsent(Object key2, @Nullable Object value2) {
        Object existing = this.store.putIfAbsent(key2, this.toStoreValue(value2));
        return this.toValueWrapper(existing);
    }

    @Override
    public void evict(Object key2) {
        this.store.remove(key2);
    }

    @Override
    public boolean evictIfPresent(Object key2) {
        return this.store.remove(key2) != null;
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public boolean invalidate() {
        boolean notEmpty = !this.store.isEmpty();
        this.store.clear();
        return notEmpty;
    }

    @Override
    protected Object toStoreValue(@Nullable Object userValue) {
        Object storeValue = super.toStoreValue(userValue);
        if (this.serialization != null) {
            try {
                return this.serialization.serializeToByteArray(storeValue);
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Failed to serialize cache value '" + userValue + "'. Does it implement Serializable?", ex);
            }
        }
        return storeValue;
    }

    @Override
    @Nullable
    protected Object fromStoreValue(@Nullable Object storeValue) {
        if (storeValue != null && this.serialization != null) {
            try {
                return super.fromStoreValue(this.serialization.deserializeFromByteArray((byte[])storeValue));
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Failed to deserialize cache value '" + storeValue + "'", ex);
            }
        }
        return super.fromStoreValue(storeValue);
    }

    private /* synthetic */ Object lambda$retrieve$1(Supplier valueLoader, Object k) {
        return this.toStoreValue(((CompletableFuture)valueLoader.get()).join());
    }
}

