/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.springframework.lang.Nullable;

public interface Cache {
    public String getName();

    public Object getNativeCache();

    @Nullable
    public ValueWrapper get(Object var1);

    @Nullable
    public <T> T get(Object var1, @Nullable Class<T> var2);

    @Nullable
    public <T> T get(Object var1, Callable<T> var2);

    @Nullable
    default public CompletableFuture<?> retrieve(Object key2) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support CompletableFuture-based retrieval");
    }

    default public <T> CompletableFuture<T> retrieve(Object key2, Supplier<CompletableFuture<T>> valueLoader) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support CompletableFuture-based retrieval");
    }

    public void put(Object var1, @Nullable Object var2);

    @Nullable
    default public ValueWrapper putIfAbsent(Object key2, @Nullable Object value2) {
        ValueWrapper existingValue = this.get(key2);
        if (existingValue == null) {
            this.put(key2, value2);
        }
        return existingValue;
    }

    public void evict(Object var1);

    default public boolean evictIfPresent(Object key2) {
        this.evict(key2);
        return false;
    }

    public void clear();

    default public boolean invalidate() {
        this.clear();
        return false;
    }

    @FunctionalInterface
    public static interface ValueWrapper {
        @Nullable
        public Object get();
    }

    public static class ValueRetrievalException
    extends RuntimeException {
        @Nullable
        private final Object key;

        public ValueRetrievalException(@Nullable Object key2, Callable<?> loader, @Nullable Throwable ex) {
            super(String.format("Value for key '%s' could not be loaded using '%s'", key2, loader), ex);
            this.key = key2;
        }

        @Nullable
        public Object getKey() {
            return this.key;
        }
    }
}

