/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet.server;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.logging.Log;

class DocumentRoot {
    private static final String[] COMMON_DOC_ROOTS = new String[]{"src/main/webapp", "public", "static"};
    private final Log logger;
    private File directory;

    DocumentRoot(Log logger) {
        this.logger = logger;
    }

    File getDirectory() {
        return this.directory;
    }

    void setDirectory(File directory) {
        this.directory = directory;
    }

    final File getValidDirectory() {
        File file2 = this.directory;
        file2 = file2 != null ? file2 : this.getWarFileDocumentRoot();
        file2 = file2 != null ? file2 : this.getExplodedWarFileDocumentRoot();
        File file3 = file2 = file2 != null ? file2 : this.getCommonDocumentRoot();
        if (file2 == null && this.logger.isDebugEnabled()) {
            this.logNoDocumentRoots();
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Document root: " + file2);
        }
        return file2;
    }

    private File getWarFileDocumentRoot() {
        return this.getArchiveFileDocumentRoot(".war");
    }

    private File getArchiveFileDocumentRoot(String extension) {
        File file2 = this.getCodeSourceArchive();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Code archive: " + file2);
        }
        if (file2 != null && file2.exists() && !file2.isDirectory() && file2.getName().toLowerCase(Locale.ENGLISH).endsWith(extension)) {
            return file2.getAbsoluteFile();
        }
        return null;
    }

    private File getExplodedWarFileDocumentRoot() {
        return this.getExplodedWarFileDocumentRoot(this.getCodeSourceArchive());
    }

    private File getCodeSourceArchive() {
        return this.getCodeSourceArchive(this.getClass().getProtectionDomain().getCodeSource());
    }

    File getCodeSourceArchive(CodeSource codeSource) {
        try {
            String path2;
            URL location;
            URL uRL = location = codeSource != null ? codeSource.getLocation() : null;
            if (location == null) {
                return null;
            }
            URLConnection connection = location.openConnection();
            if (connection instanceof JarURLConnection) {
                JarURLConnection jarURLConnection = (JarURLConnection)connection;
                path2 = jarURLConnection.getJarFile().getName();
            } else {
                path2 = location.toURI().getPath();
            }
            int index2 = path2.indexOf("!/");
            if (index2 != -1) {
                path2 = path2.substring(0, index2);
            }
            return new File(path2);
        }
        catch (Exception ex) {
            return null;
        }
    }

    final File getExplodedWarFileDocumentRoot(File codeSourceFile) {
        String path2;
        int webInfPathIndex;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Code archive: " + codeSourceFile);
        }
        if (codeSourceFile != null && codeSourceFile.exists() && (webInfPathIndex = (path2 = codeSourceFile.getAbsolutePath()).indexOf(File.separatorChar + "WEB-INF" + File.separatorChar)) >= 0) {
            path2 = path2.substring(0, webInfPathIndex);
            return new File(path2);
        }
        return null;
    }

    private File getCommonDocumentRoot() {
        for (String commonDocRoot : COMMON_DOC_ROOTS) {
            File root = new File(commonDocRoot);
            if (!root.exists() || !root.isDirectory()) continue;
            return root.getAbsoluteFile();
        }
        return null;
    }

    private void logNoDocumentRoots() {
        this.logger.debug("None of the document roots " + Arrays.asList(COMMON_DOC_ROOTS) + " point to a directory and will be ignored.");
    }
}

