/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet.error;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.validation.method.MethodValidationResult;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Order(value=-2147483648)
public class DefaultErrorAttributes
implements ErrorAttributes,
HandlerExceptionResolver,
Ordered {
    private static final String ERROR_INTERNAL_ATTRIBUTE = DefaultErrorAttributes.class.getName() + ".ERROR";

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Override
    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        this.storeErrorAttributes(request, ex);
        return null;
    }

    private void storeErrorAttributes(HttpServletRequest request, Exception ex) {
        request.setAttribute(ERROR_INTERNAL_ATTRIBUTE, ex);
    }

    @Override
    public Map<String, Object> getErrorAttributes(WebRequest webRequest, ErrorAttributeOptions options2) {
        Map<String, Object> errorAttributes = this.getErrorAttributes(webRequest, options2.isIncluded(ErrorAttributeOptions.Include.STACK_TRACE));
        options2.retainIncluded(errorAttributes);
        return errorAttributes;
    }

    private Map<String, Object> getErrorAttributes(WebRequest webRequest, boolean includeStackTrace) {
        LinkedHashMap<String, Object> errorAttributes = new LinkedHashMap<String, Object>();
        errorAttributes.put("timestamp", new Date());
        this.addStatus(errorAttributes, webRequest);
        this.addErrorDetails(errorAttributes, webRequest, includeStackTrace);
        this.addPath(errorAttributes, webRequest);
        return errorAttributes;
    }

    private void addStatus(Map<String, Object> errorAttributes, RequestAttributes requestAttributes) {
        Integer status2 = (Integer)this.getAttribute(requestAttributes, "jakarta.servlet.error.status_code");
        if (status2 == null) {
            errorAttributes.put("status", 999);
            errorAttributes.put("error", "None");
            return;
        }
        errorAttributes.put("status", status2);
        try {
            errorAttributes.put("error", HttpStatus.valueOf(status2).getReasonPhrase());
        }
        catch (Exception ex) {
            errorAttributes.put("error", "Http Status " + status2);
        }
    }

    private void addErrorDetails(Map<String, Object> errorAttributes, WebRequest webRequest, boolean includeStackTrace) {
        Throwable error2 = this.getError(webRequest);
        if (error2 != null) {
            while (error2 instanceof ServletException && error2.getCause() != null) {
                error2 = error2.getCause();
            }
            errorAttributes.put("exception", error2.getClass().getName());
            if (includeStackTrace) {
                this.addStackTrace(errorAttributes, error2);
            }
        }
        this.addErrorMessage(errorAttributes, webRequest, error2);
    }

    private void addErrorMessage(Map<String, Object> errorAttributes, WebRequest webRequest, Throwable error2) {
        BindingResult bindingResult = this.extractBindingResult(error2);
        if (bindingResult != null) {
            this.addMessageAndErrorsFromBindingResult(errorAttributes, bindingResult);
        } else {
            MethodValidationResult methodValidationResult = this.extractMethodValidationResult(error2);
            if (methodValidationResult != null) {
                this.addMessageAndErrorsFromMethodValidationResult(errorAttributes, methodValidationResult);
            } else {
                this.addExceptionErrorMessage(errorAttributes, webRequest, error2);
            }
        }
    }

    private void addExceptionErrorMessage(Map<String, Object> errorAttributes, WebRequest webRequest, Throwable error2) {
        errorAttributes.put("message", this.getMessage(webRequest, error2));
    }

    protected String getMessage(WebRequest webRequest, Throwable error2) {
        Object message2 = this.getAttribute(webRequest, "jakarta.servlet.error.message");
        if (!ObjectUtils.isEmpty(message2)) {
            return message2.toString();
        }
        if (error2 != null && StringUtils.hasLength(error2.getMessage())) {
            return error2.getMessage();
        }
        return "No message available";
    }

    private void addMessageAndErrorsFromBindingResult(Map<String, Object> errorAttributes, BindingResult result2) {
        this.addMessageAndErrorsForValidationFailure(errorAttributes, "object='" + result2.getObjectName() + "'", result2.getAllErrors());
    }

    private void addMessageAndErrorsFromMethodValidationResult(Map<String, Object> errorAttributes, MethodValidationResult result2) {
        List<ObjectError> errors = result2.getAllErrors().stream().filter(ObjectError.class::isInstance).map(ObjectError.class::cast).toList();
        this.addMessageAndErrorsForValidationFailure(errorAttributes, "method='" + result2.getMethod() + "'", errors);
    }

    private void addMessageAndErrorsForValidationFailure(Map<String, Object> errorAttributes, String validated, List<ObjectError> errors) {
        errorAttributes.put("message", "Validation failed for " + validated + ". Error count: " + errors.size());
        errorAttributes.put("errors", errors);
    }

    private BindingResult extractBindingResult(Throwable error2) {
        if (error2 instanceof BindingResult) {
            BindingResult bindingResult = (BindingResult)((Object)error2);
            return bindingResult;
        }
        return null;
    }

    private MethodValidationResult extractMethodValidationResult(Throwable error2) {
        if (error2 instanceof MethodValidationResult) {
            MethodValidationResult methodValidationResult = (MethodValidationResult)((Object)error2);
            return methodValidationResult;
        }
        return null;
    }

    private void addStackTrace(Map<String, Object> errorAttributes, Throwable error2) {
        StringWriter stackTrace = new StringWriter();
        error2.printStackTrace(new PrintWriter(stackTrace));
        stackTrace.flush();
        errorAttributes.put("trace", stackTrace.toString());
    }

    private void addPath(Map<String, Object> errorAttributes, RequestAttributes requestAttributes) {
        String path2 = (String)this.getAttribute(requestAttributes, "jakarta.servlet.error.request_uri");
        if (path2 != null) {
            errorAttributes.put("path", path2);
        }
    }

    @Override
    public Throwable getError(WebRequest webRequest) {
        Throwable exception2 = (Throwable)this.getAttribute(webRequest, ERROR_INTERNAL_ATTRIBUTE);
        if (exception2 == null) {
            exception2 = (Throwable)this.getAttribute(webRequest, "jakarta.servlet.error.exception");
        }
        return exception2;
    }

    private <T> T getAttribute(RequestAttributes requestAttributes, String name2) {
        return (T)requestAttributes.getAttribute(name2, 0);
    }
}

