/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.web.servlet.DelegatingFilterProxyRegistrationBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.RegistrationBean;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class ServletContextInitializerBeans
extends AbstractCollection<ServletContextInitializer> {
    private static final String DISPATCHER_SERVLET_NAME = "dispatcherServlet";
    private static final Log logger = LogFactory.getLog(ServletContextInitializerBeans.class);
    private final Seen seen = new Seen();
    private final MultiValueMap<Class<?>, ServletContextInitializer> initializers = new LinkedMultiValueMap();
    private final List<Class<? extends ServletContextInitializer>> initializerTypes;
    private final List<ServletContextInitializer> sortedList;

    @SafeVarargs
    public ServletContextInitializerBeans(ListableBeanFactory beanFactory, Class<? extends ServletContextInitializer> ... initializerTypes) {
        this.initializerTypes = initializerTypes.length != 0 ? Arrays.asList(initializerTypes) : Collections.singletonList(ServletContextInitializer.class);
        this.addServletContextInitializerBeans(beanFactory);
        this.addAdaptableBeans(beanFactory);
        this.sortedList = this.initializers.values().stream().flatMap(value2 -> value2.stream().sorted(AnnotationAwareOrderComparator.INSTANCE)).toList();
        this.logMappings(this.initializers);
    }

    private void addServletContextInitializerBeans(ListableBeanFactory beanFactory) {
        for (Class<? extends ServletContextInitializer> initializerType : this.initializerTypes) {
            for (Map.Entry<String, ? extends ServletContextInitializer> initializerBean : this.getOrderedBeansOfType(beanFactory, initializerType)) {
                this.addServletContextInitializerBean(initializerBean.getKey(), initializerBean.getValue(), beanFactory);
            }
        }
    }

    private void addServletContextInitializerBean(String beanName, ServletContextInitializer initializer, ListableBeanFactory beanFactory) {
        if (initializer instanceof ServletRegistrationBean) {
            ServletRegistrationBean servletRegistrationBean = (ServletRegistrationBean)initializer;
            Object source2 = servletRegistrationBean.getServlet();
            this.addServletContextInitializerBean(Servlet.class, beanName, servletRegistrationBean, beanFactory, source2);
        } else if (initializer instanceof FilterRegistrationBean) {
            FilterRegistrationBean filterRegistrationBean = (FilterRegistrationBean)initializer;
            Object source3 = filterRegistrationBean.getFilter();
            this.addServletContextInitializerBean(Filter.class, beanName, filterRegistrationBean, beanFactory, source3);
        } else if (initializer instanceof DelegatingFilterProxyRegistrationBean) {
            DelegatingFilterProxyRegistrationBean registrationBean = (DelegatingFilterProxyRegistrationBean)initializer;
            String source4 = registrationBean.getTargetBeanName();
            this.addServletContextInitializerBean(Filter.class, beanName, registrationBean, beanFactory, source4);
        } else if (initializer instanceof ServletListenerRegistrationBean) {
            ServletListenerRegistrationBean registrationBean = (ServletListenerRegistrationBean)initializer;
            Object source5 = registrationBean.getListener();
            this.addServletContextInitializerBean(EventListener.class, beanName, registrationBean, beanFactory, source5);
        } else {
            this.addServletContextInitializerBean(ServletContextInitializer.class, beanName, initializer, beanFactory, initializer);
        }
    }

    private void addServletContextInitializerBean(Class<?> type2, String beanName, ServletContextInitializer initializer, ListableBeanFactory beanFactory, Object source2) {
        this.initializers.add(type2, initializer);
        if (source2 != null) {
            this.seen.add(type2, source2);
        }
        if (logger.isTraceEnabled()) {
            String resourceDescription = this.getResourceDescription(beanName, beanFactory);
            int order2 = this.getOrder(initializer);
            logger.trace("Added existing " + type2.getSimpleName() + " initializer bean '" + beanName + "'; order=" + order2 + ", resource=" + resourceDescription);
        }
    }

    private String getResourceDescription(String beanName, ListableBeanFactory beanFactory) {
        if (beanFactory instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)((Object)beanFactory);
            return registry.getBeanDefinition(beanName).getResourceDescription();
        }
        return "unknown";
    }

    protected void addAdaptableBeans(ListableBeanFactory beanFactory) {
        MultipartConfigElement multipartConfig = this.getMultipartConfig(beanFactory);
        this.addAsRegistrationBean(beanFactory, Servlet.class, new ServletRegistrationBeanAdapter(multipartConfig));
        this.addAsRegistrationBean(beanFactory, Filter.class, new FilterRegistrationBeanAdapter());
        for (Class<?> listenerType : ServletListenerRegistrationBean.getSupportedTypes()) {
            this.addAsRegistrationBean(beanFactory, EventListener.class, listenerType, new ServletListenerRegistrationBeanAdapter());
        }
    }

    private MultipartConfigElement getMultipartConfig(ListableBeanFactory beanFactory) {
        List<Map.Entry<String, MultipartConfigElement>> beans2 = this.getOrderedBeansOfType(beanFactory, MultipartConfigElement.class);
        return beans2.isEmpty() ? null : beans2.get(0).getValue();
    }

    protected <T> void addAsRegistrationBean(ListableBeanFactory beanFactory, Class<T> type2, RegistrationBeanAdapter<T> adapter) {
        this.addAsRegistrationBean(beanFactory, type2, type2, adapter);
    }

    private <T, B extends T> void addAsRegistrationBean(ListableBeanFactory beanFactory, Class<T> type2, Class<B> beanType, RegistrationBeanAdapter<T> adapter) {
        List<Map.Entry<String, B>> entries2 = this.getOrderedBeansOfType(beanFactory, beanType, this.seen);
        for (Map.Entry<String, B> entry : entries2) {
            String beanName = entry.getKey();
            B bean2 = entry.getValue();
            if (!this.seen.add(type2, bean2)) continue;
            RegistrationBean registration = adapter.createRegistrationBean(beanName, bean2, entries2.size());
            int order2 = this.getOrder(bean2);
            registration.setOrder(order2);
            this.initializers.add(type2, registration);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("Created " + type2.getSimpleName() + " initializer for bean '" + beanName + "'; order=" + order2 + ", resource=" + this.getResourceDescription(beanName, beanFactory));
        }
    }

    private int getOrder(Object value2) {
        return new AnnotationAwareOrderComparator(){

            @Override
            public int getOrder(Object obj) {
                return super.getOrder(obj);
            }
        }.getOrder(value2);
    }

    private <T> List<Map.Entry<String, T>> getOrderedBeansOfType(ListableBeanFactory beanFactory, Class<T> type2) {
        return this.getOrderedBeansOfType(beanFactory, type2, Seen.empty());
    }

    private <T> List<Map.Entry<String, T>> getOrderedBeansOfType(ListableBeanFactory beanFactory, Class<T> type2, Seen seen) {
        String[] names2 = beanFactory.getBeanNamesForType(type2, true, false);
        LinkedHashMap<String, T> map2 = new LinkedHashMap<String, T>();
        for (String name2 : names2) {
            T bean2;
            if (seen.contains(type2, name2) || ScopedProxyUtils.isScopedTarget(name2) || seen.contains(type2, bean2 = beanFactory.getBean(name2, type2))) continue;
            map2.put(name2, bean2);
        }
        ArrayList<Map.Entry<String, T>> beans2 = new ArrayList<Map.Entry<String, T>>(map2.entrySet());
        beans2.sort((o1, o2) -> AnnotationAwareOrderComparator.INSTANCE.compare(o1.getValue(), o2.getValue()));
        return beans2;
    }

    private void logMappings(MultiValueMap<Class<?>, ServletContextInitializer> initializers) {
        if (logger.isDebugEnabled()) {
            this.logMappings("filters", initializers, Filter.class, FilterRegistrationBean.class);
            this.logMappings("servlets", initializers, Servlet.class, ServletRegistrationBean.class);
        }
    }

    private void logMappings(String name2, MultiValueMap<Class<?>, ServletContextInitializer> initializers, Class<?> type2, Class<? extends RegistrationBean> registrationType) {
        ArrayList registrations = new ArrayList();
        registrations.addAll(initializers.getOrDefault(registrationType, (ServletContextInitializer)((Object)Collections.emptyList())));
        registrations.addAll(initializers.getOrDefault(type2, (ServletContextInitializer)((Object)Collections.emptyList())));
        String info = registrations.stream().map(Object::toString).collect(Collectors.joining(", "));
        logger.debug("Mapping " + name2 + ": " + info);
    }

    @Override
    public Iterator<ServletContextInitializer> iterator() {
        return this.sortedList.iterator();
    }

    @Override
    public int size() {
        return this.sortedList.size();
    }

    private static final class Seen {
        private final Map<Class<?>, Set<Object>> seen = new HashMap();

        private Seen() {
        }

        boolean add(Class<?> type2, Object object) {
            if (this.contains(type2, object)) {
                return false;
            }
            return this.seen.computeIfAbsent(type2, ignore -> new HashSet()).add(object);
        }

        boolean contains(Class<?> type2, Object object) {
            if (this.seen.isEmpty()) {
                return false;
            }
            if (type2 != ServletContextInitializer.class && this.seen.getOrDefault(type2, Collections.emptySet()).contains(object)) {
                return true;
            }
            return this.seen.getOrDefault(ServletContextInitializer.class, Collections.emptySet()).contains(object);
        }

        static Seen empty() {
            return new Seen();
        }
    }

    private static class ServletRegistrationBeanAdapter
    implements RegistrationBeanAdapter<Servlet> {
        private final MultipartConfigElement multipartConfig;

        ServletRegistrationBeanAdapter(MultipartConfigElement multipartConfig) {
            this.multipartConfig = multipartConfig;
        }

        @Override
        public RegistrationBean createRegistrationBean(String name2, Servlet source2, int totalNumberOfSourceBeans) {
            Object url;
            Object object = url = totalNumberOfSourceBeans != 1 ? "/" + name2 + "/" : "/";
            if (name2.equals(ServletContextInitializerBeans.DISPATCHER_SERVLET_NAME)) {
                url = "/";
            }
            ServletRegistrationBean<Servlet> bean2 = new ServletRegistrationBean<Servlet>(source2, new String[]{url});
            bean2.setName(name2);
            bean2.setMultipartConfig(this.multipartConfig);
            return bean2;
        }
    }

    @FunctionalInterface
    protected static interface RegistrationBeanAdapter<T> {
        public RegistrationBean createRegistrationBean(String var1, T var2, int var3);
    }

    private static final class FilterRegistrationBeanAdapter
    implements RegistrationBeanAdapter<Filter> {
        private FilterRegistrationBeanAdapter() {
        }

        @Override
        public RegistrationBean createRegistrationBean(String name2, Filter source2, int totalNumberOfSourceBeans) {
            FilterRegistrationBean<Filter> bean2 = new FilterRegistrationBean<Filter>(source2, new ServletRegistrationBean[0]);
            bean2.setName(name2);
            return bean2;
        }
    }

    private static final class ServletListenerRegistrationBeanAdapter
    implements RegistrationBeanAdapter<EventListener> {
        private ServletListenerRegistrationBeanAdapter() {
        }

        @Override
        public RegistrationBean createRegistrationBean(String name2, EventListener source2, int totalNumberOfSourceBeans) {
            return new ServletListenerRegistrationBean<EventListener>(source2);
        }
    }
}

