/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet;

import jakarta.servlet.Registration;
import jakarta.servlet.ServletContext;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.boot.web.servlet.RegistrationBean;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class DynamicRegistrationBean<D extends Registration.Dynamic>
extends RegistrationBean
implements BeanNameAware {
    private static final Log logger = LogFactory.getLog(RegistrationBean.class);
    private String name;
    private boolean asyncSupported = true;
    private Map<String, String> initParameters = new LinkedHashMap<String, String>();
    private String beanName;
    private boolean ignoreRegistrationFailure;

    public void setName(String name2) {
        Assert.hasLength(name2, "Name must not be empty");
        this.name = name2;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public void setInitParameters(Map<String, String> initParameters) {
        Assert.notNull(initParameters, "InitParameters must not be null");
        this.initParameters = new LinkedHashMap<String, String>(initParameters);
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public void addInitParameter(String name2, String value2) {
        Assert.notNull((Object)name2, "Name must not be null");
        this.initParameters.put(name2, value2);
    }

    @Override
    protected final void register(String description, ServletContext servletContext) {
        D registration = this.addRegistration(description, servletContext);
        if (registration == null) {
            if (this.ignoreRegistrationFailure) {
                logger.info(StringUtils.capitalize(description) + " was not registered (possibly already registered?)");
                return;
            }
            throw new IllegalStateException("Failed to register '%s' on the servlet context. Possibly already registered?".formatted(description));
        }
        this.configure(registration);
    }

    public void setIgnoreRegistrationFailure(boolean ignoreRegistrationFailure) {
        this.ignoreRegistrationFailure = ignoreRegistrationFailure;
    }

    @Override
    public void setBeanName(String name2) {
        this.beanName = name2;
    }

    protected abstract D addRegistration(String var1, ServletContext var2);

    protected void configure(D registration) {
        registration.setAsyncSupported(this.asyncSupported);
        if (!this.initParameters.isEmpty()) {
            registration.setInitParameters(this.initParameters);
        }
    }

    protected final String getOrDeduceName(Object value2) {
        if (this.name != null) {
            return this.name;
        }
        if (this.beanName != null) {
            return this.beanName;
        }
        return Conventions.getVariableName(value2);
    }
}

