/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server;

import org.springframework.http.HttpStatus;
import org.springframework.util.ObjectUtils;

public class ErrorPage {
    private final HttpStatus status;
    private final Class<? extends Throwable> exception;
    private final String path;

    public ErrorPage(String path2) {
        this.status = null;
        this.exception = null;
        this.path = path2;
    }

    public ErrorPage(HttpStatus status2, String path2) {
        this.status = status2;
        this.exception = null;
        this.path = path2;
    }

    public ErrorPage(Class<? extends Throwable> exception2, String path2) {
        this.status = null;
        this.exception = exception2;
        this.path = path2;
    }

    public String getPath() {
        return this.path;
    }

    public Class<? extends Throwable> getException() {
        return this.exception;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public int getStatusCode() {
        return this.status != null ? this.status.value() : 0;
    }

    public String getExceptionName() {
        return this.exception != null ? this.exception.getName() : null;
    }

    public boolean isGlobal() {
        return this.status == null && this.exception == null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ErrorPage) {
            ErrorPage other = (ErrorPage)obj;
            return ObjectUtils.nullSafeEquals(this.getExceptionName(), other.getExceptionName()) && ObjectUtils.nullSafeEquals(this.path, other.path) && this.status == other.status;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + ObjectUtils.nullSafeHashCode(this.getExceptionName());
        result2 = 31 * result2 + ObjectUtils.nullSafeHashCode(this.path);
        result2 = 31 * result2 + this.getStatusCode();
        return result2;
    }
}

