/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.api.DeploymentManager;
import org.springframework.boot.web.embedded.undertow.DeploymentManagerHttpHandlerFactory;
import org.springframework.boot.web.embedded.undertow.HttpHandlerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowWebServer;
import org.springframework.util.StringUtils;

public class UndertowServletWebServer
extends UndertowWebServer {
    private final String contextPath;
    private final DeploymentManager manager;

    public UndertowServletWebServer(Undertow.Builder builder, Iterable<HttpHandlerFactory> httpHandlerFactories, String contextPath, boolean autoStart) {
        super(builder, httpHandlerFactories, autoStart);
        this.contextPath = contextPath;
        this.manager = this.findManager(httpHandlerFactories);
    }

    private DeploymentManager findManager(Iterable<HttpHandlerFactory> httpHandlerFactories) {
        for (HttpHandlerFactory httpHandlerFactory : httpHandlerFactories) {
            if (!(httpHandlerFactory instanceof DeploymentManagerHttpHandlerFactory)) continue;
            DeploymentManagerHttpHandlerFactory deploymentManagerFactory = (DeploymentManagerHttpHandlerFactory)httpHandlerFactory;
            return deploymentManagerFactory.getDeploymentManager();
        }
        return null;
    }

    @Override
    protected HttpHandler createHttpHandler() {
        HttpHandler handler = super.createHttpHandler();
        if (StringUtils.hasLength(this.contextPath)) {
            handler = Handlers.path().addPrefixPath(this.contextPath, handler);
        }
        return handler;
    }

    @Override
    protected String getStartLogMessage() {
        String contextPath = StringUtils.hasText(this.contextPath) ? this.contextPath : "/";
        StringBuilder message2 = new StringBuilder(super.getStartLogMessage());
        message2.append(" with context path '");
        message2.append(contextPath);
        message2.append("'");
        return message2.toString();
    }

    public DeploymentManager getDeploymentManager() {
        return this.manager;
    }
}

