/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.tomcat;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.scan.StandardJarScanFilter;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.boot.web.embedded.tomcat.CompressionConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.DisableReferenceClearingContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.SslConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatEmbeddedContext;
import org.springframework.boot.web.embedded.tomcat.TomcatEmbeddedWebappClassLoader;
import org.springframework.boot.web.embedded.tomcat.TomcatProtocolHandlerCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;
import org.springframework.boot.web.reactive.server.AbstractReactiveWebServerFactory;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.WebServer;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.TomcatHttpHandlerAdapter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class TomcatReactiveWebServerFactory
extends AbstractReactiveWebServerFactory
implements ConfigurableTomcatWebServerFactory {
    private static final Log logger = LogFactory.getLog(TomcatReactiveWebServerFactory.class);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final String DEFAULT_PROTOCOL = "org.apache.coyote.http11.Http11NioProtocol";
    private File baseDirectory;
    private final List<Valve> engineValves = new ArrayList<Valve>();
    private List<LifecycleListener> contextLifecycleListeners = new ArrayList<LifecycleListener>();
    private final List<LifecycleListener> serverLifecycleListeners = TomcatReactiveWebServerFactory.getDefaultServerLifecycleListeners();
    private Set<TomcatContextCustomizer> tomcatContextCustomizers = new LinkedHashSet<TomcatContextCustomizer>();
    private Set<TomcatConnectorCustomizer> tomcatConnectorCustomizers = new LinkedHashSet<TomcatConnectorCustomizer>();
    private Set<TomcatProtocolHandlerCustomizer<?>> tomcatProtocolHandlerCustomizers = new LinkedHashSet();
    private final List<Connector> additionalTomcatConnectors = new ArrayList<Connector>();
    private String protocol = "org.apache.coyote.http11.Http11NioProtocol";
    private Charset uriEncoding = DEFAULT_CHARSET;
    private int backgroundProcessorDelay;
    private boolean disableMBeanRegistry = true;

    public TomcatReactiveWebServerFactory() {
    }

    public TomcatReactiveWebServerFactory(int port) {
        super(port);
    }

    private static List<LifecycleListener> getDefaultServerLifecycleListeners() {
        AprLifecycleListener aprLifecycleListener = new AprLifecycleListener();
        return AprLifecycleListener.isAprAvailable() ? new ArrayList<AprLifecycleListener>(Arrays.asList(aprLifecycleListener)) : new ArrayList();
    }

    @Override
    public WebServer getWebServer(HttpHandler httpHandler) {
        if (this.disableMBeanRegistry) {
            Registry.disableRegistry();
        }
        Tomcat tomcat = new Tomcat();
        File baseDir = this.baseDirectory != null ? this.baseDirectory : this.createTempDir("tomcat");
        tomcat.setBaseDir(baseDir.getAbsolutePath());
        for (LifecycleListener lifecycleListener : this.serverLifecycleListeners) {
            tomcat.getServer().addLifecycleListener(lifecycleListener);
        }
        Connector connector = new Connector(this.protocol);
        connector.setThrowOnFailure(true);
        tomcat.getService().addConnector(connector);
        this.customizeConnector(connector);
        tomcat.setConnector(connector);
        this.registerConnectorExecutor(tomcat, connector);
        tomcat.getHost().setAutoDeploy(false);
        this.configureEngine(tomcat.getEngine());
        for (Connector additionalConnector : this.additionalTomcatConnectors) {
            tomcat.getService().addConnector(additionalConnector);
            this.registerConnectorExecutor(tomcat, additionalConnector);
        }
        TomcatHttpHandlerAdapter tomcatHttpHandlerAdapter = new TomcatHttpHandlerAdapter(httpHandler);
        this.prepareContext(tomcat.getHost(), tomcatHttpHandlerAdapter);
        return this.getTomcatWebServer(tomcat);
    }

    private void registerConnectorExecutor(Tomcat tomcat, Connector connector) {
        Executor executor = connector.getProtocolHandler().getExecutor();
        if (executor instanceof org.apache.catalina.Executor) {
            org.apache.catalina.Executor executor2 = (org.apache.catalina.Executor)executor;
            tomcat.getService().addExecutor(executor2);
        }
    }

    private void configureEngine(Engine engine) {
        engine.setBackgroundProcessorDelay(this.backgroundProcessorDelay);
        for (Valve valve : this.engineValves) {
            engine.getPipeline().addValve(valve);
        }
    }

    protected void prepareContext(Host host, TomcatHttpHandlerAdapter servlet) {
        File docBase = this.createTempDir("tomcat-docbase");
        TomcatEmbeddedContext context = new TomcatEmbeddedContext();
        context.setPath("");
        context.setDocBase(docBase.getAbsolutePath());
        context.addLifecycleListener(new Tomcat.FixContextListener());
        ClassLoader parentClassLoader = ClassUtils.getDefaultClassLoader();
        context.setParentClassLoader(parentClassLoader);
        this.skipAllTldScanning(context);
        WebappLoader loader = new WebappLoader();
        loader.setLoaderInstance(new TomcatEmbeddedWebappClassLoader(parentClassLoader));
        loader.setDelegate(true);
        context.setLoader(loader);
        Tomcat.addServlet((Context)context, "httpHandlerServlet", servlet).setAsyncSupported(true);
        context.addServletMappingDecoded("/", "httpHandlerServlet");
        host.addChild(context);
        this.configureContext(context);
    }

    private void skipAllTldScanning(TomcatEmbeddedContext context) {
        StandardJarScanFilter filter2 = new StandardJarScanFilter();
        filter2.setTldSkip("*.jar");
        context.getJarScanner().setJarScanFilter(filter2);
    }

    protected void configureContext(Context context) {
        this.contextLifecycleListeners.forEach(context::addLifecycleListener);
        new DisableReferenceClearingContextCustomizer().customize(context);
        this.tomcatContextCustomizers.forEach(customizer2 -> customizer2.customize(context));
    }

    protected void customizeConnector(Connector connector) {
        Object object;
        int port = Math.max(this.getPort(), 0);
        connector.setPort(port);
        if (StringUtils.hasText(this.getServerHeader())) {
            connector.setProperty("server", this.getServerHeader());
        }
        if ((object = connector.getProtocolHandler()) instanceof AbstractProtocol) {
            AbstractProtocol abstractProtocol = (AbstractProtocol)object;
            this.customizeProtocol(abstractProtocol);
        }
        this.invokeProtocolHandlerCustomizers(connector.getProtocolHandler());
        if (this.getUriEncoding() != null) {
            connector.setURIEncoding(this.getUriEncoding().name());
        }
        if (this.getHttp2() != null && this.getHttp2().isEnabled()) {
            connector.addUpgradeProtocol(new Http2Protocol());
        }
        if (Ssl.isEnabled(this.getSsl())) {
            this.customizeSsl(connector);
        }
        CompressionConnectorCustomizer compression = new CompressionConnectorCustomizer(this.getCompression());
        compression.customize(connector);
        for (TomcatConnectorCustomizer customizer2 : this.tomcatConnectorCustomizers) {
            customizer2.customize(connector);
        }
    }

    private void invokeProtocolHandlerCustomizers(ProtocolHandler protocolHandler) {
        LambdaSafe.callbacks(TomcatProtocolHandlerCustomizer.class, this.tomcatProtocolHandlerCustomizers, protocolHandler, new Object[0]).invoke(customizer2 -> customizer2.customize(protocolHandler));
    }

    private void customizeProtocol(AbstractProtocol<?> protocol2) {
        if (this.getAddress() != null) {
            protocol2.setAddress(this.getAddress());
        }
    }

    private void customizeSsl(Connector connector) {
        SslConnectorCustomizer customizer2 = new SslConnectorCustomizer(logger, connector, this.getSsl().getClientAuth());
        customizer2.customize(this.getSslBundle(), this.getServerNameSslBundles());
        this.addBundleUpdateHandler(null, this.getSsl().getBundle(), customizer2);
        this.getSsl().getServerNameBundles().forEach(serverNameSslBundle -> this.addBundleUpdateHandler(serverNameSslBundle.serverName(), serverNameSslBundle.bundle(), customizer2));
    }

    private void addBundleUpdateHandler(String serverName, String sslBundleName, SslConnectorCustomizer customizer2) {
        if (StringUtils.hasText(sslBundleName)) {
            this.getSslBundles().addBundleUpdateHandler(sslBundleName, sslBundle -> customizer2.update(serverName, (SslBundle)sslBundle));
        }
    }

    @Override
    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    @Override
    public void setBackgroundProcessorDelay(int delay) {
        this.backgroundProcessorDelay = delay;
    }

    public void setTomcatContextCustomizers(Collection<? extends TomcatContextCustomizer> tomcatContextCustomizers) {
        Assert.notNull(tomcatContextCustomizers, "TomcatContextCustomizers must not be null");
        this.tomcatContextCustomizers = new LinkedHashSet<TomcatContextCustomizer>(tomcatContextCustomizers);
    }

    public Collection<TomcatContextCustomizer> getTomcatContextCustomizers() {
        return this.tomcatContextCustomizers;
    }

    @Override
    public void addContextCustomizers(TomcatContextCustomizer ... tomcatContextCustomizers) {
        Assert.notNull((Object)tomcatContextCustomizers, "TomcatContextCustomizers must not be null");
        this.tomcatContextCustomizers.addAll(Arrays.asList(tomcatContextCustomizers));
    }

    public void setTomcatConnectorCustomizers(Collection<? extends TomcatConnectorCustomizer> tomcatConnectorCustomizers) {
        Assert.notNull(tomcatConnectorCustomizers, "TomcatConnectorCustomizers must not be null");
        this.tomcatConnectorCustomizers = new LinkedHashSet<TomcatConnectorCustomizer>(tomcatConnectorCustomizers);
    }

    @Override
    public void addConnectorCustomizers(TomcatConnectorCustomizer ... tomcatConnectorCustomizers) {
        Assert.notNull((Object)tomcatConnectorCustomizers, "TomcatConnectorCustomizers must not be null");
        this.tomcatConnectorCustomizers.addAll(Arrays.asList(tomcatConnectorCustomizers));
    }

    public Collection<TomcatConnectorCustomizer> getTomcatConnectorCustomizers() {
        return this.tomcatConnectorCustomizers;
    }

    public void setTomcatProtocolHandlerCustomizers(Collection<? extends TomcatProtocolHandlerCustomizer<?>> tomcatProtocolHandlerCustomizers) {
        Assert.notNull(tomcatProtocolHandlerCustomizers, "TomcatProtocolHandlerCustomizers must not be null");
        this.tomcatProtocolHandlerCustomizers = new LinkedHashSet(tomcatProtocolHandlerCustomizers);
    }

    @Override
    public void addProtocolHandlerCustomizers(TomcatProtocolHandlerCustomizer<?> ... tomcatProtocolHandlerCustomizers) {
        Assert.notNull(tomcatProtocolHandlerCustomizers, "TomcatProtocolHandlerCustomizers must not be null");
        this.tomcatProtocolHandlerCustomizers.addAll(Arrays.asList(tomcatProtocolHandlerCustomizers));
    }

    public Collection<TomcatProtocolHandlerCustomizer<?>> getTomcatProtocolHandlerCustomizers() {
        return this.tomcatProtocolHandlerCustomizers;
    }

    public void addAdditionalTomcatConnectors(Connector ... connectors) {
        Assert.notNull((Object)connectors, "Connectors must not be null");
        this.additionalTomcatConnectors.addAll(Arrays.asList(connectors));
    }

    public List<Connector> getAdditionalTomcatConnectors() {
        return this.additionalTomcatConnectors;
    }

    @Override
    public void addEngineValves(Valve ... engineValves) {
        Assert.notNull((Object)engineValves, "Valves must not be null");
        this.engineValves.addAll(Arrays.asList(engineValves));
    }

    public List<Valve> getEngineValves() {
        return this.engineValves;
    }

    @Override
    public void setUriEncoding(Charset uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    public Charset getUriEncoding() {
        return this.uriEncoding;
    }

    public void setContextLifecycleListeners(Collection<? extends LifecycleListener> contextLifecycleListeners) {
        Assert.notNull(contextLifecycleListeners, "ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners = new ArrayList<LifecycleListener>(contextLifecycleListeners);
    }

    public Collection<LifecycleListener> getContextLifecycleListeners() {
        return this.contextLifecycleListeners;
    }

    public void addContextLifecycleListeners(LifecycleListener ... contextLifecycleListeners) {
        Assert.notNull((Object)contextLifecycleListeners, "ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners.addAll(Arrays.asList(contextLifecycleListeners));
    }

    protected TomcatWebServer getTomcatWebServer(Tomcat tomcat) {
        return new TomcatWebServer(tomcat, this.getPort() >= 0, this.getShutdown());
    }

    public void setProtocol(String protocol2) {
        Assert.hasLength(protocol2, "Protocol must not be empty");
        this.protocol = protocol2;
    }

    public void setDisableMBeanRegistry(boolean disableMBeanRegistry) {
        this.disableMBeanRegistry = disableMBeanRegistry;
    }
}

