/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.tomcat;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.catalina.loader.ParallelWebappClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;

public class TomcatEmbeddedWebappClassLoader
extends ParallelWebappClassLoader {
    private static final Log logger = LogFactory.getLog(TomcatEmbeddedWebappClassLoader.class);

    public TomcatEmbeddedWebappClassLoader() {
    }

    public TomcatEmbeddedWebappClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public URL findResource(String name2) {
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name2) throws IOException {
        return Collections.emptyEnumeration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name2, boolean resolve) throws ClassNotFoundException {
        TomcatEmbeddedWebappClassLoader tomcatEmbeddedWebappClassLoader = JreCompat.isGraalAvailable() ? this : this.getClassLoadingLock(name2);
        synchronized (tomcatEmbeddedWebappClassLoader) {
            Class<?> result2 = this.findExistingLoadedClass(name2);
            Class<?> clazz = result2 = result2 != null ? result2 : this.doLoadClass(name2);
            if (result2 == null) {
                throw new ClassNotFoundException(name2);
            }
            return this.resolveIfNecessary(result2, resolve);
        }
    }

    private Class<?> findExistingLoadedClass(String name2) {
        Class<?> resultClass = this.findLoadedClass0(name2);
        resultClass = resultClass != null || JreCompat.isGraalAvailable() ? resultClass : this.findLoadedClass(name2);
        return resultClass;
    }

    private Class<?> doLoadClass(String name2) {
        if (this.delegate || this.filter(name2, true)) {
            Class<?> result2 = this.loadFromParent(name2);
            return result2 != null ? result2 : this.findClassIgnoringNotFound(name2);
        }
        Class<?> result3 = this.findClassIgnoringNotFound(name2);
        return result3 != null ? result3 : this.loadFromParent(name2);
    }

    private Class<?> resolveIfNecessary(Class<?> resultClass, boolean resolve) {
        if (resolve) {
            this.resolveClass(resultClass);
        }
        return resultClass;
    }

    @Override
    protected void addURL(URL url) {
        if (logger.isTraceEnabled()) {
            logger.trace("Ignoring request to add " + url + " to the tomcat classloader");
        }
    }

    private Class<?> loadFromParent(String name2) {
        if (this.parent == null) {
            return null;
        }
        try {
            return Class.forName(name2, false, this.parent);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    private Class<?> findClassIgnoringNotFound(String name2) {
        try {
            return this.findClass(name2);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    static {
        if (!JreCompat.isGraalAvailable()) {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

