/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.tomcat;

import java.util.Map;
import org.apache.catalina.connector.Connector;
import org.apache.commons.logging.Log;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundleKey;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.boot.web.server.Ssl;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class SslConnectorCustomizer {
    private final Log logger;
    private final Ssl.ClientAuth clientAuth;
    private final Connector connector;

    SslConnectorCustomizer(Log logger, Connector connector, Ssl.ClientAuth clientAuth) {
        this.logger = logger;
        this.clientAuth = clientAuth;
        this.connector = connector;
    }

    void update(String serverName, SslBundle updatedSslBundle) {
        AbstractHttp11JsseProtocol protocol2 = (AbstractHttp11JsseProtocol)this.connector.getProtocolHandler();
        String host = serverName != null ? serverName : protocol2.getDefaultSSLHostConfigName();
        this.logger.debug("SSL Bundle for host " + host + " has been updated, reloading SSL configuration");
        this.addSslHostConfig(protocol2, host, updatedSslBundle);
    }

    void customize(SslBundle sslBundle, Map<String, SslBundle> serverNameSslBundles) {
        ProtocolHandler handler = this.connector.getProtocolHandler();
        Assert.state(handler instanceof AbstractHttp11JsseProtocol, "To use SSL, the connector's protocol handler must be an AbstractHttp11JsseProtocol subclass");
        this.configureSsl((AbstractHttp11JsseProtocol)handler, sslBundle, serverNameSslBundles);
        this.connector.setScheme("https");
        this.connector.setSecure(true);
    }

    private void configureSsl(AbstractHttp11JsseProtocol<?> protocol2, SslBundle sslBundle, Map<String, SslBundle> serverNameSslBundles) {
        protocol2.setSSLEnabled(true);
        if (sslBundle != null) {
            this.addSslHostConfig(protocol2, protocol2.getDefaultSSLHostConfigName(), sslBundle);
        }
        serverNameSslBundles.forEach((serverName, bundle) -> this.addSslHostConfig(protocol2, (String)serverName, (SslBundle)bundle));
    }

    private void addSslHostConfig(AbstractHttp11JsseProtocol<?> protocol2, String serverName, SslBundle sslBundle) {
        SSLHostConfig sslHostConfig = new SSLHostConfig();
        sslHostConfig.setHostName(serverName);
        this.configureSslClientAuth(sslHostConfig);
        this.applySslBundle(protocol2, sslHostConfig, sslBundle);
        protocol2.addSslHostConfig(sslHostConfig, true);
    }

    private void applySslBundle(AbstractHttp11JsseProtocol<?> protocol2, SSLHostConfig sslHostConfig, SslBundle sslBundle) {
        SslBundleKey key2 = sslBundle.getKey();
        SslStoreBundle stores = sslBundle.getStores();
        SslOptions options2 = sslBundle.getOptions();
        sslHostConfig.setSslProtocol(sslBundle.getProtocol());
        SSLHostConfigCertificate certificate = new SSLHostConfigCertificate(sslHostConfig, SSLHostConfigCertificate.Type.UNDEFINED);
        String keystorePassword = stores.getKeyStorePassword() != null ? stores.getKeyStorePassword() : "";
        certificate.setCertificateKeystorePassword(keystorePassword);
        if (key2.getPassword() != null) {
            certificate.setCertificateKeyPassword(key2.getPassword());
        }
        if (key2.getAlias() != null) {
            certificate.setCertificateKeyAlias(key2.getAlias());
        }
        sslHostConfig.addCertificate(certificate);
        if (options2.getCiphers() != null) {
            String ciphers = StringUtils.arrayToCommaDelimitedString(options2.getCiphers());
            sslHostConfig.setCiphers(ciphers);
        }
        this.configureSslStores(sslHostConfig, certificate, stores);
        this.configureEnabledProtocols(sslHostConfig, options2);
    }

    private void configureEnabledProtocols(SSLHostConfig sslHostConfig, SslOptions options2) {
        if (options2.getEnabledProtocols() != null) {
            String enabledProtocols = StringUtils.arrayToDelimitedString(options2.getEnabledProtocols(), "+");
            sslHostConfig.setProtocols(enabledProtocols);
        }
    }

    private void configureSslClientAuth(SSLHostConfig config) {
        config.setCertificateVerification(Ssl.ClientAuth.map(this.clientAuth, "none", "optional", "required"));
    }

    private void configureSslStores(SSLHostConfig sslHostConfig, SSLHostConfigCertificate certificate, SslStoreBundle stores) {
        try {
            if (stores.getKeyStore() != null) {
                certificate.setCertificateKeystore(stores.getKeyStore());
            }
            if (stores.getTrustStore() != null) {
                sslHostConfig.setTrustStore(stores.getTrustStore());
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not load store: " + ex.getMessage(), ex);
        }
    }
}

