/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.jetty;

import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.Callback;
import org.springframework.boot.web.server.Compression;

final class JettyHandlerWrappers {
    private JettyHandlerWrappers() {
    }

    static Handler.Wrapper createGzipHandlerWrapper(Compression compression) {
        GzipHandler handler = new GzipHandler();
        handler.setMinGzipSize((int)compression.getMinResponseSize().toBytes());
        handler.setIncludedMimeTypes(compression.getMimeTypes());
        for (HttpMethod httpMethod : HttpMethod.values()) {
            handler.addIncludedMethods(new String[]{httpMethod.name()});
        }
        return handler;
    }

    static Handler.Wrapper createServerHeaderHandlerWrapper(String header) {
        return new ServerHeaderHandler(header);
    }

    private static class ServerHeaderHandler
    extends Handler.Wrapper {
        private static final String SERVER_HEADER = "server";
        private final String value;

        ServerHeaderHandler(String value2) {
            this.value = value2;
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            HttpFields.Mutable headers = response.getHeaders();
            if (!headers.contains(SERVER_HEADER)) {
                headers.add(SERVER_HEADER, this.value);
            }
            return super.handle(request, response, callback);
        }
    }
}

