/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.jetty;

import jakarta.servlet.ServletContainerInitializer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import org.apache.catalina.webresources.TomcatURLStreamHandlerFactory;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.springframework.util.ClassUtils;

class JasperInitializer
extends AbstractLifeCycle {
    private static final String[] INITIALIZER_CLASSES = new String[]{"org.eclipse.jetty.apache.jsp.JettyJasperInitializer", "org.apache.jasper.servlet.JasperInitializer"};
    private final WebAppContext context;
    private final ServletContainerInitializer initializer;

    JasperInitializer(WebAppContext context) {
        this.context = context;
        this.initializer = this.newInitializer();
    }

    private ServletContainerInitializer newInitializer() {
        for (String className : INITIALIZER_CLASSES) {
            try {
                Class<?> initializerClass = ClassUtils.forName(className, null);
                return (ServletContainerInitializer)initializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception2) {
            }
        }
        return null;
    }

    protected void doStart() throws Exception {
        if (this.initializer == null) {
            return;
        }
        if (ClassUtils.isPresent("org.apache.catalina.webresources.TomcatURLStreamHandlerFactory", ((Object)((Object)this)).getClass().getClassLoader())) {
            TomcatURLStreamHandlerFactory.register();
        } else {
            try {
                URL.setURLStreamHandlerFactory(new WarUrlStreamHandlerFactory());
            }
            catch (Error error2) {
                // empty catch block
            }
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.context.getClassLoader());
            try {
                this.context.getContext().setExtendedListenerTypes(true);
                this.initializer.onStartup(null, this.context.getServletContext());
            }
            finally {
                this.context.getContext().setExtendedListenerTypes(false);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static final class WarUrlStreamHandlerFactory
    implements URLStreamHandlerFactory {
        private WarUrlStreamHandlerFactory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol2) {
            if ("war".equals(protocol2)) {
                return new WarUrlStreamHandler();
            }
            return null;
        }
    }

    private static class WarURLConnection
    extends URLConnection {
        private final URLConnection connection;

        protected WarURLConnection(URL url) throws IOException {
            super(url);
            this.connection = new URL(url.getFile()).openConnection();
        }

        @Override
        public void connect() throws IOException {
            if (!this.connected) {
                this.connection.connect();
                this.connected = true;
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.connection.getInputStream();
        }
    }

    private static final class WarUrlStreamHandler
    extends URLStreamHandler {
        private WarUrlStreamHandler() {
        }

        @Override
        protected void parseURL(URL u, String spec, int start2, int limit2) {
            String path2 = "jar:" + spec.substring("war:".length());
            int separator = path2.indexOf("*/");
            if (separator >= 0) {
                path2 = path2.substring(0, separator) + "!/" + path2.substring(separator + 2);
            }
            this.setURL(u, u.getProtocol(), "", -1, null, null, path2, null, null);
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new WarURLConnection(u);
        }
    }
}

