/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.jetty;

import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.springframework.boot.web.server.GracefulShutdownCallback;
import org.springframework.boot.web.server.GracefulShutdownResult;
import org.springframework.util.ReflectionUtils;

final class GracefulShutdown {
    private static final Log logger = LogFactory.getLog(GracefulShutdown.class);
    private final Server server;
    private final Supplier<Integer> activeRequests;
    private volatile boolean aborted = false;

    GracefulShutdown(Server server, Supplier<Integer> activeRequests) {
        this.server = server;
        this.activeRequests = activeRequests;
    }

    void shutDownGracefully(GracefulShutdownCallback callback) {
        logger.info("Commencing graceful shutdown. Waiting for active requests to complete");
        new Thread(() -> this.awaitShutdown(callback), "jetty-shutdown").start();
        boolean jetty10 = this.isJetty10();
        for (Connector connector : this.server.getConnectors()) {
            this.shutdown(connector, !jetty10);
        }
    }

    private void shutdown(Connector connector, boolean getResult) {
        Future result2;
        try {
            result2 = connector.shutdown();
        }
        catch (NoSuchMethodError ex) {
            Method shutdown2 = ReflectionUtils.findMethod(connector.getClass(), "shutdown");
            result2 = (Future)ReflectionUtils.invokeMethod(shutdown2, connector);
        }
        if (getResult) {
            try {
                result2.get();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    private boolean isJetty10() {
        try {
            return CompletableFuture.class.equals(Connector.class.getMethod("shutdown", new Class[0]).getReturnType());
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void awaitShutdown(GracefulShutdownCallback callback) {
        while (!this.aborted && this.activeRequests.get() > 0) {
            this.sleep(100L);
        }
        if (this.aborted) {
            logger.info("Graceful shutdown aborted with one or more requests still active");
            callback.shutdownComplete(GracefulShutdownResult.REQUESTS_ACTIVE);
        } else {
            logger.info("Graceful shutdown complete");
            callback.shutdownComplete(GracefulShutdownResult.IDLE);
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    void abort() {
        this.aborted = true;
    }
}

