/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.context;

import java.io.File;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.system.SystemProperties;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class WebServerPortFileWriter
implements ApplicationListener<WebServerInitializedEvent> {
    private static final String DEFAULT_FILE_NAME = "application.port";
    private static final String[] PROPERTY_VARIABLES = new String[]{"PORTFILE", "portfile"};
    private static final Log logger = LogFactory.getLog(WebServerPortFileWriter.class);
    private final File file;

    public WebServerPortFileWriter() {
        this(new File(DEFAULT_FILE_NAME));
    }

    public WebServerPortFileWriter(String filename2) {
        this(new File(filename2));
    }

    public WebServerPortFileWriter(File file2) {
        Assert.notNull((Object)file2, "File must not be null");
        String override = SystemProperties.get(PROPERTY_VARIABLES);
        this.file = override != null ? new File(override) : file2;
    }

    @Override
    public void onApplicationEvent(WebServerInitializedEvent event2) {
        File portFile = this.getPortFile(event2.getApplicationContext());
        try {
            String port = String.valueOf(event2.getWebServer().getPort());
            this.createParentDirectory(portFile);
            FileCopyUtils.copy(port.getBytes(), portFile);
            portFile.deleteOnExit();
        }
        catch (Exception ex) {
            logger.warn(LogMessage.format("Cannot create port file %s", (Object)this.file));
        }
    }

    protected File getPortFile(ApplicationContext applicationContext) {
        String namespace = this.getServerNamespace(applicationContext);
        if (!StringUtils.hasLength(namespace)) {
            return this.file;
        }
        Object name2 = this.file.getName();
        String extension = StringUtils.getFilenameExtension(this.file.getName());
        name2 = this.isUpperCase((String)(name2 = ((String)name2).substring(0, ((String)name2).length() - extension.length() - 1))) ? (String)name2 + "-" + namespace.toUpperCase(Locale.ENGLISH) : (String)name2 + "-" + namespace.toLowerCase(Locale.ENGLISH);
        if (StringUtils.hasLength(extension)) {
            name2 = (String)name2 + "." + extension;
        }
        return new File(this.file.getParentFile(), (String)name2);
    }

    private String getServerNamespace(ApplicationContext applicationContext) {
        if (applicationContext instanceof WebServerApplicationContext) {
            WebServerApplicationContext webServerApplicationContext = (WebServerApplicationContext)applicationContext;
            return webServerApplicationContext.getServerNamespace();
        }
        return null;
    }

    private boolean isUpperCase(String name2) {
        for (int i2 = 0; i2 < name2.length(); ++i2) {
            if (!Character.isLetter(name2.charAt(i2)) || Character.isUpperCase(name2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private void createParentDirectory(File file2) {
        File parent = file2.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }
}

