/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.context;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.util.StringUtils;

public class ServerPortInfoApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
ApplicationListener<WebServerInitializedEvent> {
    private static final String PROPERTY_SOURCE_NAME = "server.ports";

    @Override
    public void initialize(ConfigurableApplicationContext applicationContext) {
        applicationContext.addApplicationListener(this);
    }

    @Override
    public void onApplicationEvent(WebServerInitializedEvent event2) {
        String propertyName = "local." + this.getName(event2.getApplicationContext()) + ".port";
        this.setPortProperty(event2.getApplicationContext(), propertyName, event2.getWebServer().getPort());
    }

    private String getName(WebServerApplicationContext context) {
        String name2 = context.getServerNamespace();
        return StringUtils.hasText(name2) ? name2 : "server";
    }

    private void setPortProperty(ApplicationContext context, String propertyName, int port) {
        if (context instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)context;
            this.setPortProperty(configurableContext.getEnvironment(), propertyName, port);
        }
        if (context.getParent() != null) {
            this.setPortProperty(context.getParent(), propertyName, port);
        }
    }

    private void setPortProperty(ConfigurableEnvironment environment2, String propertyName, int port) {
        MutablePropertySources sources = environment2.getPropertySources();
        MapPropertySource source2 = sources.get(PROPERTY_SOURCE_NAME);
        if (source2 == null) {
            source2 = new MapPropertySource(PROPERTY_SOURCE_NAME, (Map<String, Object>)new HashMap<String, Object>());
            sources.addFirst(source2);
        }
        ((Map)source2.getSource()).put(propertyName, port);
    }
}

