/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.client;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.http.client.AbstractClientHttpRequestFactoryWrapper;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.JettyClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class ClientHttpRequestFactoriesRuntimeHints
implements RuntimeHintsRegistrar {
    ClientHttpRequestFactoriesRuntimeHints() {
    }

    @Override
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        if (ClassUtils.isPresent("org.springframework.http.client.ClientHttpRequestFactory", classLoader)) {
            this.registerHints(hints.reflection(), classLoader);
        }
    }

    private void registerHints(ReflectionHints hints, ClassLoader classLoader) {
        hints.registerField(this.findField(AbstractClientHttpRequestFactoryWrapper.class, "requestFactory"));
        hints.registerTypeIfPresent(classLoader, "org.apache.hc.client5.http.impl.classic.HttpClients", typeHint -> {
            typeHint.onReachableType(TypeReference.of("org.apache.hc.client5.http.impl.classic.HttpClients"));
            this.registerReflectionHints(hints, HttpComponentsClientHttpRequestFactory.class);
        });
        hints.registerTypeIfPresent(classLoader, "org.eclipse.jetty.client.HttpClient", typeHint -> {
            typeHint.onReachableType(TypeReference.of("org.eclipse.jetty.client.HttpClient"));
            this.registerReflectionHints(hints, JettyClientHttpRequestFactory.class, Long.TYPE);
        });
        hints.registerType(SimpleClientHttpRequestFactory.class, typeHint -> {
            typeHint.onReachableType(HttpURLConnection.class);
            this.registerReflectionHints(hints, SimpleClientHttpRequestFactory.class);
        });
        this.registerOkHttpHints(hints, classLoader);
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    private void registerOkHttpHints(ReflectionHints hints, ClassLoader classLoader) {
        hints.registerTypeIfPresent(classLoader, "okhttp3.OkHttpClient", typeHint -> {
            typeHint.onReachableType(TypeReference.of("okhttp3.OkHttpClient"));
            this.registerReflectionHints(hints, OkHttp3ClientHttpRequestFactory.class);
        });
    }

    private void registerReflectionHints(ReflectionHints hints, Class<? extends ClientHttpRequestFactory> requestFactoryType) {
        this.registerReflectionHints(hints, requestFactoryType, Integer.TYPE);
    }

    private void registerReflectionHints(ReflectionHints hints, Class<? extends ClientHttpRequestFactory> requestFactoryType, Class<?> readTimeoutType) {
        this.registerMethod(hints, requestFactoryType, "setConnectTimeout", Integer.TYPE);
        this.registerMethod(hints, requestFactoryType, "setReadTimeout", readTimeoutType);
    }

    private void registerMethod(ReflectionHints hints, Class<? extends ClientHttpRequestFactory> requestFactoryType, String methodName, Class<?> ... parameterTypes) {
        Method method2 = ReflectionUtils.findMethod(requestFactoryType, methodName, parameterTypes);
        if (method2 != null) {
            hints.registerMethod(method2, ExecutableMode.INVOKE);
        }
    }

    private Field findField(Class<?> type2, String name2) {
        Field field = ReflectionUtils.findField(type2, name2);
        Assert.state(field != null, () -> "Unable to find field '%s' on %s".formatted(type2.getName(), name2));
        return field;
    }
}

