/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.client;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.transport.HttpClientTransportDynamic;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.web.client.ClientHttpRequestFactorySettings;
import org.springframework.http.client.AbstractClientHttpRequestFactoryWrapper;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.JdkClientHttpRequestFactory;
import org.springframework.http.client.JettyClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class ClientHttpRequestFactories {
    static final String APACHE_HTTP_CLIENT_CLASS = "org.apache.hc.client5.http.impl.classic.HttpClients";
    private static final boolean APACHE_HTTP_CLIENT_PRESENT = ClassUtils.isPresent("org.apache.hc.client5.http.impl.classic.HttpClients", null);
    static final String OKHTTP_CLIENT_CLASS = "okhttp3.OkHttpClient";
    private static final boolean OKHTTP_CLIENT_PRESENT = ClassUtils.isPresent("okhttp3.OkHttpClient", null);
    static final String JETTY_CLIENT_CLASS = "org.eclipse.jetty.client.HttpClient";
    private static final boolean JETTY_CLIENT_PRESENT = ClassUtils.isPresent("org.eclipse.jetty.client.HttpClient", null);

    private ClientHttpRequestFactories() {
    }

    public static ClientHttpRequestFactory get(ClientHttpRequestFactorySettings settings) {
        Assert.notNull((Object)settings, "Settings must not be null");
        if (APACHE_HTTP_CLIENT_PRESENT) {
            return HttpComponents.get(settings);
        }
        if (JETTY_CLIENT_PRESENT) {
            return Jetty.get(settings);
        }
        if (OKHTTP_CLIENT_PRESENT) {
            return OkHttp.get(settings);
        }
        return Simple.get(settings);
    }

    public static <T extends ClientHttpRequestFactory> T get(Class<T> requestFactoryType, ClientHttpRequestFactorySettings settings) {
        Assert.notNull((Object)settings, "Settings must not be null");
        if (requestFactoryType == ClientHttpRequestFactory.class) {
            return (T)ClientHttpRequestFactories.get(settings);
        }
        if (requestFactoryType == HttpComponentsClientHttpRequestFactory.class) {
            return (T)HttpComponents.get(settings);
        }
        if (requestFactoryType == JettyClientHttpRequestFactory.class) {
            return (T)Jetty.get(settings);
        }
        if (requestFactoryType == JdkClientHttpRequestFactory.class) {
            return (T)Jdk.get(settings);
        }
        if (requestFactoryType == SimpleClientHttpRequestFactory.class) {
            return (T)Simple.get(settings);
        }
        if (requestFactoryType == OkHttp3ClientHttpRequestFactory.class) {
            return (T)OkHttp.get(settings);
        }
        return (T)ClientHttpRequestFactories.get(() -> ClientHttpRequestFactories.createRequestFactory(requestFactoryType), settings);
    }

    public static <T extends ClientHttpRequestFactory> T get(Supplier<T> requestFactorySupplier, ClientHttpRequestFactorySettings settings) {
        return Reflective.get(requestFactorySupplier, settings);
    }

    private static <T extends ClientHttpRequestFactory> T createRequestFactory(Class<T> requestFactory) {
        try {
            Constructor<T> constructor2 = requestFactory.getDeclaredConstructor(new Class[0]);
            constructor2.setAccessible(true);
            return (T)((ClientHttpRequestFactory)constructor2.newInstance(new Object[0]));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    static class HttpComponents {
        HttpComponents() {
        }

        static HttpComponentsClientHttpRequestFactory get(ClientHttpRequestFactorySettings settings) {
            HttpComponentsClientHttpRequestFactory requestFactory = HttpComponents.createRequestFactory(settings.readTimeout(), settings.sslBundle());
            PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map2.from(settings::connectTimeout).asInt(Duration::toMillis).to(requestFactory::setConnectTimeout);
            return requestFactory;
        }

        private static HttpComponentsClientHttpRequestFactory createRequestFactory(Duration readTimeout, SslBundle sslBundle) {
            return new HttpComponentsClientHttpRequestFactory(HttpComponents.createHttpClient(readTimeout, sslBundle));
        }

        private static org.apache.hc.client5.http.classic.HttpClient createHttpClient(Duration readTimeout, SslBundle sslBundle) {
            PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
            if (readTimeout != null) {
                SocketConfig socketConfig = SocketConfig.custom().setSoTimeout((int)readTimeout.toMillis(), TimeUnit.MILLISECONDS).build();
                connectionManagerBuilder.setDefaultSocketConfig(socketConfig);
            }
            if (sslBundle != null) {
                SslOptions options2 = sslBundle.getOptions();
                SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslBundle.createSslContext(), options2.getEnabledProtocols(), options2.getCiphers(), (HostnameVerifier)new DefaultHostnameVerifier());
                connectionManagerBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
            }
            PoolingHttpClientConnectionManager connectionManager = connectionManagerBuilder.useSystemProperties().build();
            return HttpClientBuilder.create().useSystemProperties().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        }
    }

    static class Jetty {
        Jetty() {
        }

        static JettyClientHttpRequestFactory get(ClientHttpRequestFactorySettings settings) {
            JettyClientHttpRequestFactory requestFactory = Jetty.createRequestFactory(settings.sslBundle());
            PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map2.from(settings::connectTimeout).asInt(Duration::toMillis).to(requestFactory::setConnectTimeout);
            map2.from(settings::readTimeout).asInt(Duration::toMillis).to(requestFactory::setReadTimeout);
            return requestFactory;
        }

        private static JettyClientHttpRequestFactory createRequestFactory(SslBundle sslBundle) {
            if (sslBundle != null) {
                SSLContext sslContext = sslBundle.createSslContext();
                SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
                sslContextFactory.setSslContext(sslContext);
                ClientConnector connector = new ClientConnector();
                connector.setSslContextFactory(sslContextFactory);
                HttpClient httpClient = new HttpClient((HttpClientTransport)new HttpClientTransportDynamic(connector, new ClientConnectionFactory.Info[0]));
                return new JettyClientHttpRequestFactory(httpClient);
            }
            return new JettyClientHttpRequestFactory();
        }
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    static class OkHttp {
        OkHttp() {
        }

        static OkHttp3ClientHttpRequestFactory get(ClientHttpRequestFactorySettings settings) {
            OkHttp3ClientHttpRequestFactory requestFactory = OkHttp.createRequestFactory(settings.sslBundle());
            PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map2.from(settings::connectTimeout).asInt(Duration::toMillis).to(requestFactory::setConnectTimeout);
            map2.from(settings::readTimeout).asInt(Duration::toMillis).to(requestFactory::setReadTimeout);
            return requestFactory;
        }

        private static OkHttp3ClientHttpRequestFactory createRequestFactory(SslBundle sslBundle) {
            if (sslBundle != null) {
                Assert.state(!sslBundle.getOptions().isSpecified(), "SSL Options cannot be specified with OkHttp");
                SSLSocketFactory socketFactory = sslBundle.createSslContext().getSocketFactory();
                TrustManager[] trustManagers = sslBundle.getManagers().getTrustManagers();
                Assert.state(trustManagers.length == 1, "Trust material must be provided in the SSL bundle for OkHttp3ClientHttpRequestFactory");
                OkHttpClient client = new OkHttpClient.Builder().sslSocketFactory(socketFactory, (X509TrustManager)trustManagers[0]).build();
                return new OkHttp3ClientHttpRequestFactory(client);
            }
            return new OkHttp3ClientHttpRequestFactory();
        }
    }

    static class Simple {
        Simple() {
        }

        static SimpleClientHttpRequestFactory get(ClientHttpRequestFactorySettings settings) {
            SslBundle sslBundle = settings.sslBundle();
            SimpleClientHttpRequestFactory requestFactory = sslBundle != null ? new SimpleClientHttpsRequestFactory(sslBundle) : new SimpleClientHttpRequestFactory();
            Assert.state(sslBundle == null || !sslBundle.getOptions().isSpecified(), "SSL Options cannot be specified with Java connections");
            PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map2.from(settings::readTimeout).asInt(Duration::toMillis).to(requestFactory::setReadTimeout);
            map2.from(settings::connectTimeout).asInt(Duration::toMillis).to(requestFactory::setConnectTimeout);
            return requestFactory;
        }

        private static class SimpleClientHttpsRequestFactory
        extends SimpleClientHttpRequestFactory {
            private final SslBundle sslBundle;

            SimpleClientHttpsRequestFactory(SslBundle sslBundle) {
                this.sslBundle = sslBundle;
            }

            @Override
            protected void prepareConnection(HttpURLConnection connection, String httpMethod) throws IOException {
                super.prepareConnection(connection, httpMethod);
                if (this.sslBundle != null && connection instanceof HttpsURLConnection) {
                    HttpsURLConnection secureConnection = (HttpsURLConnection)connection;
                    SSLSocketFactory socketFactory = this.sslBundle.createSslContext().getSocketFactory();
                    secureConnection.setSSLSocketFactory(socketFactory);
                }
            }
        }
    }

    static class Jdk {
        Jdk() {
        }

        static JdkClientHttpRequestFactory get(ClientHttpRequestFactorySettings settings) {
            java.net.http.HttpClient httpClient = Jdk.createHttpClient(settings.connectTimeout(), settings.sslBundle());
            JdkClientHttpRequestFactory requestFactory = new JdkClientHttpRequestFactory(httpClient);
            PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map2.from(settings::readTimeout).to(requestFactory::setReadTimeout);
            return requestFactory;
        }

        private static java.net.http.HttpClient createHttpClient(Duration connectTimeout, SslBundle sslBundle) {
            HttpClient.Builder builder = java.net.http.HttpClient.newBuilder();
            if (connectTimeout != null) {
                builder.connectTimeout(connectTimeout);
            }
            if (sslBundle != null) {
                builder.sslContext(sslBundle.createSslContext());
            }
            return builder.build();
        }
    }

    static class Reflective {
        Reflective() {
        }

        static <T extends ClientHttpRequestFactory> T get(Supplier<T> requestFactorySupplier, ClientHttpRequestFactorySettings settings) {
            ClientHttpRequestFactory requestFactory = (ClientHttpRequestFactory)requestFactorySupplier.get();
            Reflective.configure(requestFactory, settings);
            return (T)requestFactory;
        }

        private static void configure(ClientHttpRequestFactory requestFactory, ClientHttpRequestFactorySettings settings) {
            ClientHttpRequestFactory unwrapped = Reflective.unwrapRequestFactoryIfNecessary(requestFactory);
            PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map2.from(settings::connectTimeout).to(connectTimeout -> Reflective.setConnectTimeout(unwrapped, connectTimeout));
            map2.from(settings::readTimeout).to(readTimeout -> Reflective.setReadTimeout(unwrapped, readTimeout));
        }

        private static ClientHttpRequestFactory unwrapRequestFactoryIfNecessary(ClientHttpRequestFactory requestFactory) {
            if (!(requestFactory instanceof AbstractClientHttpRequestFactoryWrapper)) {
                return requestFactory;
            }
            Field field = ReflectionUtils.findField(AbstractClientHttpRequestFactoryWrapper.class, "requestFactory");
            ReflectionUtils.makeAccessible(field);
            ClientHttpRequestFactory unwrappedRequestFactory = requestFactory;
            while (unwrappedRequestFactory instanceof AbstractClientHttpRequestFactoryWrapper) {
                unwrappedRequestFactory = (ClientHttpRequestFactory)ReflectionUtils.getField(field, unwrappedRequestFactory);
            }
            return unwrappedRequestFactory;
        }

        private static void setConnectTimeout(ClientHttpRequestFactory factory, Duration connectTimeout) {
            Method method2 = Reflective.tryFindMethod(factory, "setConnectTimeout", Duration.class);
            if (method2 != null) {
                Reflective.invoke(factory, method2, connectTimeout);
                return;
            }
            method2 = Reflective.findMethod(factory, "setConnectTimeout", Integer.TYPE);
            int timeout2 = Math.toIntExact(connectTimeout.toMillis());
            Reflective.invoke(factory, method2, timeout2);
        }

        private static void setReadTimeout(ClientHttpRequestFactory factory, Duration readTimeout) {
            Method method2 = Reflective.tryFindMethod(factory, "setReadTimeout", Duration.class);
            if (method2 != null) {
                Reflective.invoke(factory, method2, readTimeout);
                return;
            }
            method2 = Reflective.findMethod(factory, "setReadTimeout", Integer.TYPE);
            int timeout2 = Math.toIntExact(readTimeout.toMillis());
            Reflective.invoke(factory, method2, timeout2);
        }

        private static Method findMethod(ClientHttpRequestFactory requestFactory, String methodName, Class<?> ... parameters2) {
            Method method2 = ReflectionUtils.findMethod(requestFactory.getClass(), methodName, parameters2);
            Assert.state(method2 != null, () -> "Request factory %s does not have a suitable %s method".formatted(requestFactory.getClass().getName(), methodName));
            Assert.state(!method2.isAnnotationPresent(Deprecated.class), () -> "Request factory %s has the %s method marked as deprecated".formatted(requestFactory.getClass().getName(), methodName));
            return method2;
        }

        private static Method tryFindMethod(ClientHttpRequestFactory requestFactory, String methodName, Class<?> ... parameters2) {
            Method method2 = ReflectionUtils.findMethod(requestFactory.getClass(), methodName, parameters2);
            if (method2 == null) {
                return null;
            }
            if (method2.isAnnotationPresent(Deprecated.class)) {
                return null;
            }
            return method2;
        }

        private static void invoke(ClientHttpRequestFactory requestFactory, Method method2, Object ... parameters2) {
            ReflectionUtils.invokeMethod(method2, requestFactory, parameters2);
        }
    }
}

