/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.util;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class Instantiator<T> {
    private static final Comparator<Constructor<?>> CONSTRUCTOR_COMPARATOR = Comparator.comparingInt(Constructor::getParameterCount).reversed();
    private static final FailureHandler throwingFailureHandler = (type2, implementationName, failure) -> {
        throw new IllegalArgumentException("Unable to instantiate " + implementationName + " [" + type2.getName() + "]", failure);
    };
    private final Class<?> type;
    private final Map<Class<?>, Function<Class<?>, Object>> availableParameters;
    private final FailureHandler failureHandler;

    public Instantiator(Class<?> type2, Consumer<AvailableParameters> availableParameters) {
        this(type2, availableParameters, throwingFailureHandler);
    }

    public Instantiator(Class<?> type2, Consumer<AvailableParameters> availableParameters, FailureHandler failureHandler) {
        this.type = type2;
        this.availableParameters = this.getAvailableParameters(availableParameters);
        this.failureHandler = failureHandler;
    }

    private Map<Class<?>, Function<Class<?>, Object>> getAvailableParameters(Consumer<AvailableParameters> availableParameters) {
        final LinkedHashMap result2 = new LinkedHashMap();
        availableParameters.accept(new AvailableParameters(){

            @Override
            public void add(Class<?> type2, Object instance) {
                result2.put(type2, factoryType -> instance);
            }

            @Override
            public void add(Class<?> type2, Function<Class<?>, Object> factory) {
                result2.put(type2, factory);
            }
        });
        return Collections.unmodifiableMap(result2);
    }

    public List<T> instantiate(Collection<String> names2) {
        return this.instantiate(null, names2);
    }

    public List<T> instantiate(ClassLoader classLoader, Collection<String> names2) {
        Assert.notNull(names2, "Names must not be null");
        return this.instantiate(names2.stream().map(name2 -> TypeSupplier.forName(classLoader, name2)));
    }

    public List<T> instantiateTypes(Collection<Class<?>> types) {
        Assert.notNull(types, "Types must not be null");
        return this.instantiate(types.stream().map(TypeSupplier::forType));
    }

    private List<T> instantiate(Stream<TypeSupplier> typeSuppliers) {
        return typeSuppliers.map(this::instantiate).sorted(AnnotationAwareOrderComparator.INSTANCE).toList();
    }

    private T instantiate(TypeSupplier typeSupplier) {
        try {
            Class<?> type2 = typeSupplier.get();
            Assert.isAssignable(this.type, type2);
            return this.instantiate(type2);
        }
        catch (Throwable ex) {
            this.failureHandler.handleFailure(this.type, typeSupplier.getName(), ex);
            return null;
        }
    }

    private T instantiate(Class<?> type2) throws Exception {
        Constructor<?>[] constructors2 = type2.getDeclaredConstructors();
        Arrays.sort(constructors2, CONSTRUCTOR_COMPARATOR);
        for (Constructor<?> constructor2 : constructors2) {
            Object[] args2 = this.getArgs(constructor2.getParameterTypes());
            if (args2 == null) continue;
            ReflectionUtils.makeAccessible(constructor2);
            return (T)constructor2.newInstance(args2);
        }
        throw new IllegalAccessException("Class [" + type2.getName() + "] has no suitable constructor");
    }

    private Object[] getArgs(Class<?>[] parameterTypes) {
        Object[] args2 = new Object[parameterTypes.length];
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            Function<Class<?>, Object> parameter = this.getAvailableParameter(parameterTypes[i2]);
            if (parameter == null) {
                return null;
            }
            args2[i2] = parameter.apply(this.type);
        }
        return args2;
    }

    private Function<Class<?>, Object> getAvailableParameter(Class<?> parameterType) {
        for (Map.Entry<Class<?>, Function<Class<?>, Object>> entry : this.availableParameters.entrySet()) {
            if (!entry.getKey().isAssignableFrom(parameterType)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static interface FailureHandler {
        public void handleFailure(Class<?> var1, String var2, Throwable var3);
    }

    private static interface TypeSupplier {
        public String getName();

        public Class<?> get() throws ClassNotFoundException;

        public static TypeSupplier forName(final ClassLoader classLoader, final String name2) {
            return new TypeSupplier(){

                @Override
                public String getName() {
                    return name2;
                }

                @Override
                public Class<?> get() throws ClassNotFoundException {
                    return ClassUtils.forName(name2, classLoader);
                }
            };
        }

        public static TypeSupplier forType(final Class<?> type2) {
            return new TypeSupplier(){

                @Override
                public String getName() {
                    return type2.getName();
                }

                @Override
                public Class<?> get() throws ClassNotFoundException {
                    return type2;
                }
            };
        }
    }

    public static interface AvailableParameters {
        public void add(Class<?> var1, Object var2);

        public void add(Class<?> var1, Function<Class<?>, Object> var2);
    }
}

